/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.util.HeightUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class ChunkUpdateTask
implements MapTask,
BiomeManager.NoiseBiomeSource {
    private static final int[] ALL_BLOCKS = (int[])Util.make((Object)new int[256], array -> {
        for (int i = 0; i < 256; ++i) {
            array[i] = i;
        }
    });
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");
    private static long debugLastTime = 0L;
    private MapManager manager;
    private final Level level;
    private final ChunkAccess chunkAccess;
    private final ChunkPos chunkPos;
    private final int[] blocksToUpdate;
    private final long taskStartTime;

    public ChunkUpdateTask(@Nullable MapManager manager, Level level, ChunkAccess chunkAccess, ChunkPos chunkPos) {
        this(manager, level, chunkAccess, chunkPos, ALL_BLOCKS);
    }

    public ChunkUpdateTask(@Nullable MapManager manager, Level level, ChunkAccess chunkAccess, ChunkPos chunkPos, int[] blocksToUpdate) {
        this.manager = manager;
        this.level = level;
        this.chunkAccess = chunkAccess;
        this.chunkPos = chunkPos;
        this.blocksToUpdate = blocksToUpdate;
        this.taskStartTime = System.currentTimeMillis();
    }

    public static void init() {
        debugLastTime = 0L;
    }

    public static long getDebugLastTime() {
        return debugLastTime;
    }

    @Override
    public void runMapTask() throws Exception {
        boolean versionChange;
        while (this.manager == null) {
            this.manager = MapManager.getInstance().orElse(null);
            if (this.manager != null) continue;
            if (System.currentTimeMillis() - this.taskStartTime >= 30000L) {
                return;
            }
            Thread.sleep(1L);
        }
        if (this.manager.isInvalid()) {
            return;
        }
        long startTime = System.nanoTime();
        ResourceKey dimId = this.level.dimension();
        MapChunk mapChunk = this.manager.getDimension((ResourceKey<Level>)dimId).getRegion(XZ.regionFromChunk((ChunkPos)this.chunkPos)).getDataBlocking().getChunk(XZ.of((ChunkPos)this.chunkPos));
        MapRegionData data = mapChunk.getRegionData();
        Registry biomes = this.level.registryAccess().registryOrThrow(Registries.BIOME);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int blockX = this.chunkPos.getMinBlockX();
        int blockZ = this.chunkPos.getMinBlockZ();
        boolean changed = false;
        boolean bl = versionChange = mapChunk.getVersion() != 4;
        if (versionChange) {
            mapChunk.setVersion(4);
            changed = true;
        }
        for (int wi : this.blocksToUpdate) {
            int wx = wi % 16;
            int wz = wi / 16;
            blockPos.set(blockX + wx, this.chunkAccess.getHeight(Heightmap.Types.MOTION_BLOCKING, blockX + wx, blockZ + wz) + 2, blockZ + wz);
            int waterY = Mth.clamp((int)HeightUtils.getHeight(this.level, this.chunkAccess, blockPos), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            int height = blockPos.getY();
            BlockState state = this.chunkAccess.getBlockState((BlockPos)blockPos);
            int ax = mapChunk.getPos().x() * 16 + wx;
            int az = mapChunk.getPos().z() * 16 + wz;
            int index = ax + az * 512;
            int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
            int blockIndex0 = data.getBlockIndex(index);
            short height0 = data.height[index];
            blockPos.setY(waterY == -32767 ? height : waterY);
            int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
            waterLightAndBiome |= waterY != -32767 ? 32768 : 0;
            waterLightAndBiome |= (this.level.getBrightness(LightLayer.BLOCK, (BlockPos)blockPos) & 0xF) << 11;
            ResourceLocation id = state == null ? AIR : FTBChunks.BLOCK_REGISTRY.getId((Object)state.getBlock());
            int blockIndex = this.manager.getBlockColorIndex(id == null ? AIR : id);
            Biome biome = (Biome)this.getNoiseBiome(blockPos.getX() >> 2, blockPos.getY() >> 2, blockPos.getZ() >> 2).value();
            waterLightAndBiome &= 0xF800;
            waterLightAndBiome |= this.manager.getBiomeColorIndex((Registry<Biome>)biomes, biome, biome) & 0x7FF;
            if (versionChange || height0 != height) {
                data.height[index] = (short)height;
                changed = true;
            }
            if (versionChange || waterLightAndBiome0 != waterLightAndBiome) {
                data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                if (biome != null && (versionChange || (waterLightAndBiome0 & 0x7FF) != (waterLightAndBiome & 0x7FF))) {
                    double cx = blockPos.getX();
                    double cz = blockPos.getZ();
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | BiomeColors.FOLIAGE_COLOR_RESOLVER.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | BiomeColors.GRASS_COLOR_RESOLVER.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | BiomeColors.WATER_COLOR_RESOLVER.getColor(biome, cx, cz) & 0xFFFFFF;
                }
                changed = true;
            }
            if (!versionChange && blockIndex0 == blockIndex) continue;
            data.setBlockIndex(index, blockIndex);
            changed = true;
        }
        if (changed) {
            mapChunk.forceUpdate();
        }
        debugLastTime = System.nanoTime() - startTime;
    }

    public String toString() {
        return "ChunkUpdateTask@" + this.chunkPos;
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        if (x >> 2 == this.chunkPos.x && z >> 2 == this.chunkPos.z) {
            return this.chunkAccess.getNoiseBiome(x, y, z);
        }
        return this.level.getNoiseBiome(x, y, z);
    }
}

