/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.BiomeBlendMode;
import dev.ftb.mods.ftbchunks.client.map.ColorsFromRegion;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.client.map.color.CustomBlockColor;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;

public class RenderMapImageTask
implements MapTask {
    private static boolean alwaysRenderChunksOnMap = false;
    public final MapRegion region;
    private static final boolean exportImages = false;

    public RenderMapImageTask(MapRegion r) {
        this.region = r;
    }

    private static int getHeight(MapMode m, int whf, short data, short height) {
        if (((data & 0xFFFF) >> 15 & 1) != 0 && m != MapMode.TOPOGRAPHY) {
            if (whf == 0) {
                return 62;
            }
            return height / whf * whf + whf - 1;
        }
        return height;
    }

    public static void setAlwaysRenderChunksOnMap(boolean alwaysRenderChunksOnMap) {
        RenderMapImageTask.alwaysRenderChunksOnMap = alwaysRenderChunksOnMap;
    }

    private int[][] initColors(BiomeBlendMode blendMode, MapRegionData data, ColorsFromRegion getter) {
        int j;
        int i;
        int[] colors = getter.getColors(data);
        int blend = blendMode.getBlendRadius();
        int size = 512 + blend * 2;
        int[][] newColors = new int[size][size];
        int posX = this.region.pos.x();
        int posZ = this.region.pos.z();
        int[] rWW = blend == 0 ? null : this.region.dimension.getColors(posX - 1, posZ, getter);
        int[] rEE = blend == 0 ? null : this.region.dimension.getColors(posX + 1, posZ, getter);
        int[] rNN = blend == 0 ? null : this.region.dimension.getColors(posX, posZ - 1, getter);
        int[] rSS = blend == 0 ? null : this.region.dimension.getColors(posX, posZ + 1, getter);
        int[] rNW = blend == 0 ? null : this.region.dimension.getColors(posX - 1, posZ - 1, getter);
        int[] rSW = blend == 0 ? null : this.region.dimension.getColors(posX - 1, posZ + 1, getter);
        int[] rNE = blend == 0 ? null : this.region.dimension.getColors(posX + 1, posZ - 1, getter);
        int[] rSE = blend == 0 ? null : this.region.dimension.getColors(posX + 1, posZ + 1, getter);
        for (i = 0; i < 512; ++i) {
            for (j = 0; j < 512; ++j) {
                newColors[i + blend][j + blend] = colors[i + j * 512];
            }
            for (j = 0; j < blend; ++j) {
                if (rWW != null) {
                    newColors[j][i + blend] = rWW[j + 512 - blend + i * 512];
                }
                if (rEE != null) {
                    newColors[j + 512 + blend][i + blend] = rEE[j + i * 512];
                }
                if (rNN != null) {
                    newColors[i + blend][j] = rNN[i + (j + 512 - blend) * 512];
                }
                if (rSS == null) continue;
                newColors[i + blend][j + blend + 512] = rSS[i + j * 512];
            }
        }
        for (i = 0; i < blend; ++i) {
            for (j = 0; j < blend; ++j) {
                if (rNW != null) {
                    newColors[i][j] = rNW[i + 512 - blend + (j + 512 - blend) * 512];
                }
                if (rNE != null) {
                    newColors[i + 512 + blend][j] = rNE[i + (j + 512 - blend) * 512];
                }
                if (rSW != null) {
                    newColors[i][j + 512 + blend] = rSW[i + 512 - blend + j * 512];
                }
                if (rSE == null) continue;
                newColors[i + 512 + blend][j + 512 + blend] = rSE[i + j * 512];
            }
        }
        return newColors;
    }

    private int[][] initFoliage(BiomeBlendMode blend, MapRegionData data) {
        return this.initColors(blend, data, ColorsFromRegion.FOLIAGE);
    }

    private int[][] initGrass(BiomeBlendMode blend, MapRegionData data) {
        return this.initColors(blend, data, ColorsFromRegion.GRASS);
    }

    private int[][] initWater(BiomeBlendMode blend, MapRegionData data) {
        return this.initColors(blend, data, ColorsFromRegion.WATER);
    }

    private Color4I getColor(BiomeBlendMode blendMode, int[][] colors, int ax, int az) {
        return blendMode.doBlending(colors, ax, az);
    }

    @Override
    public void runMapTask() {
        MapRegion rNorth;
        if (this.region.dimension.getManager().isInvalid()) {
            return;
        }
        BiomeBlendMode blend = (BiomeBlendMode)((Object)FTBChunksClientConfig.BIOME_BLEND.get());
        MapRegionData data = this.region.getDataBlocking();
        short[] heightW = new short[512];
        short[] heightN = new short[512];
        short[] waterLightAndBiomeW = new short[512];
        short[] waterLightAndBiomeN = new short[512];
        int[][] foliage = null;
        int[][] grass = null;
        int[][] water = null;
        MapRegion rWest = this.region.dimension.getRegions().get(this.region.pos.offset(-1, 0));
        if (rWest != null) {
            MapRegionData d = rWest.getDataBlocking();
            for (int i = 0; i < 512; ++i) {
                heightW[i] = d.height[511 + i * 512];
                waterLightAndBiomeW[i] = d.waterLightAndBiome[511 + i * 512];
            }
        } else {
            for (int i = 0; i < 512; ++i) {
                heightW[i] = data.height[i * 512];
                waterLightAndBiomeW[i] = data.waterLightAndBiome[i * 512];
            }
        }
        if ((rNorth = this.region.dimension.getRegions().get(this.region.pos.offset(0, -1))) != null) {
            MapRegionData d = rNorth.getDataBlocking();
            System.arraycopy(d.height, 261632, heightN, 0, 512);
            System.arraycopy(d.waterLightAndBiome, 261632, waterLightAndBiomeN, 0, 512);
        } else {
            System.arraycopy(data.height, 0, heightN, 0, 512);
            System.arraycopy(data.waterLightAndBiome, 0, waterLightAndBiomeN, 0, 512);
        }
        float[] hsb = new float[3];
        Team ownTeam = FTBTeamsAPI.api().getClientManager().selfTeam();
        ClientLevel world = Minecraft.getInstance().level;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        MapMode mapMode = (MapMode)((Object)FTBChunksClientConfig.MAP_MODE.get());
        int waterHeightFactor = (Integer)FTBChunksClientConfig.WATER_HEIGHT_FACTOR.get();
        float noise = ((Double)FTBChunksClientConfig.NOISE.get()).floatValue();
        boolean ownClaimedChunksOnMap = (Boolean)FTBChunksClientConfig.OWN_CLAIMED_CHUNKS_ON_MAP.get();
        boolean claimedChunksOnMap = (Boolean)FTBChunksClientConfig.CLAIMED_CHUNKS_ON_MAP.get();
        float saturation = ((Double)FTBChunksClientConfig.SATURATION.get()).floatValue();
        float shadows = ((Double)FTBChunksClientConfig.SHADOWS.get()).floatValue();
        int foliageDarkness = (Integer)FTBChunksClientConfig.FOLIAGE_DARKNESS.get();
        int grassDarkness = (Integer)FTBChunksClientConfig.GRASS_DARKNESS.get();
        int waterVisibility = (Integer)FTBChunksClientConfig.WATER_VISIBILITY.get();
        boolean reducedColorPalette = (Boolean)FTBChunksClientConfig.REDUCED_COLOR_PALETTE.get();
        boolean chunkGrid = (Boolean)FTBChunksClientConfig.CHUNK_GRID.get();
        Color4I weakLoadedTint = Color4I.rgba((int)255, (int)180, (int)0, (int)20);
        Color4I weakLoadedTint2 = Color4I.rgba((int)255, (int)180, (int)0, (int)100);
        Color4I strongLoadedTint = Color4I.RED.withAlpha(60);
        Color4I strongLoadedTint2 = Color4I.RED.withAlpha(140);
        for (int cz = 0; cz < 32; ++cz) {
            for (int cx = 0; cx < 32; ++cx) {
                boolean claimBarRight;
                boolean claimBarLeft;
                boolean claimBarDown;
                boolean claimBarUp;
                int fullClaimColor;
                Color4I claimColor;
                boolean isOwnChunk;
                int loadedView = this.region.dimension.getLoadedView(this.region, cx, cz);
                MapChunk c = this.region.getMapChunk(XZ.of((int)cx, (int)cz));
                Random random = new Random(this.region.pos.toLong() ^ (c == null ? 0L : c.getPos().toLong()));
                boolean bl = isOwnChunk = c != null && c.getTeam().isPresent() && ownTeam.getTeamId().equals(c.getTeam().get().getTeamId());
                if (c != null && c.getClaimedDate().isPresent() && (alwaysRenderChunksOnMap || (isOwnChunk ? ownClaimedChunksOnMap : claimedChunksOnMap))) {
                    claimColor = ((Color4I)c.getTeam().get().getProperty((TeamProperty)TeamProperties.COLOR)).withAlpha(100);
                    fullClaimColor = ColorUtils.convertToNative(0xFF000000 | claimColor.rgb());
                    claimBarUp = !c.connects(c.offsetBlocking(0, -1));
                    claimBarDown = !c.connects(c.offsetBlocking(0, 1));
                    claimBarLeft = !c.connects(c.offsetBlocking(-1, 0));
                    claimBarRight = !c.connects(c.offsetBlocking(1, 0));
                } else {
                    claimColor = Color4I.empty();
                    fullClaimColor = 0;
                    claimBarUp = false;
                    claimBarDown = false;
                    claimBarLeft = false;
                    claimBarRight = false;
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        Color4I col;
                        boolean tint2;
                        int ax = cx * 16 + x;
                        int az = cz * 16 + z;
                        int index = ax + az * 512;
                        boolean bl2 = tint2 = ax % 4 == (az % 2 == 0 ? 0 : 2);
                        if (c == null) {
                            if (loadedView == 1) {
                                this.region.setRenderedMapImageRGBA(ax, az, ColorUtils.convertToNative(0xFF000000 | Color4I.BLACK.withTint(tint2 ? weakLoadedTint2 : weakLoadedTint).rgb()));
                                continue;
                            }
                            if (loadedView == 2) {
                                this.region.setRenderedMapImageRGBA(ax, az, ColorUtils.convertToNative(0xFF000000 | Color4I.BLACK.withTint(tint2 ? strongLoadedTint2 : strongLoadedTint).rgb()));
                                continue;
                            }
                            this.region.setRenderedMapImageRGBA(ax, az, 0);
                            continue;
                        }
                        BlockColor blockColor = this.region.dimension.getManager().getBlockColor(data.getBlockIndex(index));
                        int by = RenderMapImageTask.getHeight(mapMode, waterHeightFactor, data.waterLightAndBiome[index], data.height[index]);
                        boolean hasWater = (data.waterLightAndBiome[index] >> 15 & 1) != 0;
                        blockPos.set(this.region.pos.x() * 512 + ax, by, this.region.pos.z() * 512 + az);
                        if (mapMode == MapMode.TOPOGRAPHY) {
                            col = ColorUtils.getTopographyPalette()[by + (hasWater ? 256 : 0)];
                        } else if (mapMode == MapMode.BLOCKS) {
                            col = Color4I.rgb((int)data.getBlockIndex(index));
                        } else if (mapMode == MapMode.LIGHT_SOURCES) {
                            col = ColorUtils.getLightMapPalette()[15][data.waterLightAndBiome[index] >> 11 & 0xF];
                        } else {
                            if (claimBarUp && z == 0 || claimBarDown && z == 15 || claimBarLeft && x == 0 || claimBarRight && x == 15) {
                                this.region.setRenderedMapImageRGBA(ax, az, fullClaimColor);
                                continue;
                            }
                            if (blockColor instanceof CustomBlockColor) {
                                CustomBlockColor cbc = (CustomBlockColor)blockColor;
                                col = cbc.getColor();
                            } else if (blockColor == BlockColors.FOLIAGE) {
                                if (foliage == null) {
                                    foliage = this.initFoliage(blend, data);
                                }
                                col = this.getColor(blend, foliage, ax, az).withAlpha(255).withTint(Color4I.BLACK.withAlpha(foliageDarkness));
                            } else if (blockColor == BlockColors.GRASS) {
                                if (grass == null) {
                                    grass = this.initGrass(blend, data);
                                }
                                col = this.getColor(blend, grass, ax, az).withAlpha(255).withTint(Color4I.BLACK.withAlpha(grassDarkness));
                            } else {
                                col = blockColor.getBlockColor((BlockAndTintGetter)world, (BlockPos)blockPos).withAlpha(255);
                            }
                            if (mapMode == MapMode.NIGHT) {
                                col = col.withTint(ColorUtils.getLightMapPalette()[data.waterLightAndBiome[index] >> 11 & 0xF][15].withAlpha(230));
                            }
                            if (hasWater) {
                                if (water == null) {
                                    water = this.initWater(blend, data);
                                }
                                col = col.withTint(this.getColor(blend, water, ax, az).withAlpha(waterVisibility));
                            }
                            if (reducedColorPalette) {
                                col = ColorUtils.reduce(col);
                            }
                        }
                        if (saturation < 1.0f) {
                            Color.RGBtoHSB(col.redi(), col.greeni(), col.bluei(), hsb);
                            hsb[1] = hsb[1] * saturation;
                            col = Color4I.hsb((float)hsb[0], (float)hsb[1], (float)hsb[2]);
                        }
                        float addedBrightness = 0.0f;
                        if (shadows > 0.0f) {
                            int bn = RenderMapImageTask.getHeight(mapMode, waterHeightFactor, az == 0 ? waterLightAndBiomeN[ax] : data.waterLightAndBiome[ax + (az - 1) * 512], az == 0 ? heightN[ax] : data.height[ax + (az - 1) * 512]);
                            int bw = RenderMapImageTask.getHeight(mapMode, waterHeightFactor, ax == 0 ? waterLightAndBiomeW[az] : data.waterLightAndBiome[ax - 1 + az * 512], ax == 0 ? heightW[az] : data.height[ax - 1 + az * 512]);
                            if (by > bn || by > bw) {
                                addedBrightness += shadows * (hasWater ? 0.6f : 1.0f);
                            }
                            if (by < bn || by < bw) {
                                addedBrightness -= shadows * (hasWater ? 0.6f : 1.0f);
                            }
                        }
                        if (noise > 0.0f) {
                            addedBrightness += random.nextFloat() * noise - noise / 2.0f;
                        }
                        if (addedBrightness != 0.0f) {
                            col = ColorUtils.addBrightness(col, addedBrightness);
                        }
                        if (chunkGrid && (x == 0 || z == 0)) {
                            col = col.withTint(MapRegion.GRID_COLOR);
                        }
                        if (loadedView == 0 && !claimColor.isEmpty()) {
                            col = col.withTint(claimColor);
                        }
                        if (loadedView == 1) {
                            col = col.withTint(tint2 ? weakLoadedTint2 : weakLoadedTint);
                        } else if (loadedView == 2) {
                            col = col.withTint(tint2 ? strongLoadedTint2 : strongLoadedTint);
                        }
                        this.region.setRenderedMapImageRGBA(ax, az, ColorUtils.convertToNative(0xFF000000 | col.rgb()));
                    }
                }
            }
        }
        this.region.afterImageRenderTask();
    }

    public String toString() {
        return "RenderMapImageTask@" + this.region.pos;
    }
}

