/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public enum ClaimExpirationManager {
    INSTANCE;

    private static final long RUN_INTERVAL = 600000L;
    private static final long DAYS_TO_MILLIS = 86400000L;
    private long lastRun = 0L;

    public void tick(MinecraftServer server) {
        long now;
        if ((server.getTickCount() & 0x3F) == 0 && (now = System.currentTimeMillis()) - this.lastRun > 600000L) {
            Map<UUID, Collection<ClaimedChunk>> chunkMap = FTBChunksAPI.api().getManager().getClaimedChunksByTeam(cc -> !(cc.getTeamData().getTeam() instanceof ServerTeam));
            this.checkForIdleTeams(server, now, chunkMap);
            this.checkForTemporaryClaims(server, now, chunkMap);
            this.lastRun = now;
        }
    }

    private void checkForIdleTeams(MinecraftServer server, long now, Map<UUID, Collection<ClaimedChunk>> chunkMap) {
        long maxClaim = (long)((Double)FTBChunksWorldConfig.MAX_IDLE_DAYS_BEFORE_UNCLAIM.get() * 8.64E7);
        long maxForce = (long)((Double)FTBChunksWorldConfig.MAX_IDLE_DAYS_BEFORE_UNFORCE.get() * 8.64E7);
        if (maxClaim == 0L && maxForce == 0L) {
            return;
        }
        ArrayList expiredClaims = new ArrayList();
        ArrayList expiredForceloads = new ArrayList();
        chunkMap.forEach((id, chunks) -> {
            ArrayList toExpireClaims = new ArrayList();
            ArrayList toExpireForce = new ArrayList();
            chunks.forEach(cc -> {
                ChunkTeamData teamData = cc.getTeamData();
                if (maxClaim > 0L && now - teamData.getLastLoginTime() > maxClaim && teamData.getTeam().getOnlineMembers().isEmpty()) {
                    toExpireClaims.add(cc);
                }
                if (maxForce > 0L && cc.isForceLoaded() && now - teamData.getLastLoginTime() > maxForce && teamData.getTeam().getOnlineMembers().isEmpty()) {
                    toExpireForce.add(cc);
                }
            });
            if (!toExpireClaims.isEmpty()) {
                FTBChunks.LOGGER.info("all chunk claims for team {} have expired due to team inactivity; unclaiming {} chunks", (Object)id.toString(), (Object)toExpireClaims.size());
                expiredClaims.addAll(toExpireClaims);
            }
            if (!toExpireForce.isEmpty()) {
                FTBChunks.LOGGER.info("all forceloads for team {} have expired due to team inactivity; unforcing {} chunks", (Object)id.toString(), (Object)toExpireForce.size());
                expiredForceloads.addAll(toExpireForce);
            }
        });
        CommandSourceStack sourceStack = server.createCommandSourceStack();
        HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>>();
        if (!expiredForceloads.isEmpty()) {
            expiredForceloads.forEach(cc -> ClaimExpirationManager.unloadChunk(now, cc, toSync, sourceStack));
        }
        if (!expiredClaims.isEmpty()) {
            expiredClaims.forEach(cc -> ClaimExpirationManager.unclaimChunk(now, cc, toSync, sourceStack));
        }
        if (!toSync.isEmpty()) {
            ClaimExpirationManager.syncChunks(toSync, server, Util.NIL_UUID);
        }
    }

    private void checkForTemporaryClaims(MinecraftServer server, long now, Map<UUID, Collection<ClaimedChunk>> chunkMap) {
        chunkMap.forEach((teamId, chunks) -> {
            List<ClaimedChunk> expired = chunks.stream().filter(cc -> cc.isForceLoaded() && cc.hasForceLoadExpired(now)).toList();
            if (!expired.isEmpty()) {
                ChunkTeamData teamData = expired.get(0).getTeamData();
                CommandSourceStack sourceStack = server.createCommandSourceStack();
                HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>>();
                expired.forEach(cc -> {
                    FTBChunks.LOGGER.info("un-forceloading chunk {} - expiry time {} passed", cc, (Object)cc.getForceLoadExpiryTime());
                    ClaimExpirationManager.unloadChunk(now, cc, toSync, sourceStack);
                });
                ClaimExpirationManager.syncChunks(toSync, server, teamData.getTeam().getId());
            }
        });
    }

    private static void unclaimChunk(long now, ClaimedChunk c, Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, CommandSourceStack sourceStack) {
        c.unclaim(sourceStack, false);
        toSync.computeIfAbsent((ResourceKey<Level>)c.getPos().dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.getPos().x(), c.getPos().z(), null));
    }

    private static void unloadChunk(long now, ClaimedChunk c, Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, CommandSourceStack sourceStack) {
        c.unload(sourceStack);
        toSync.computeIfAbsent((ResourceKey<Level>)c.getPos().dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.getPos().x(), c.getPos().z(), c));
    }

    private static void syncChunks(Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> toSync, MinecraftServer server, UUID teamId) {
        toSync.forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                new SendManyChunksPacket((ResourceKey<Level>)dimension, teamId, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(server);
            }
        });
    }
}

