/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.neoforge;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.neoforge.ForceLoading;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="ftbchunks")
public class FTBChunksForge {
    public FTBChunksForge(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.addListener(this::entityInteractSpecific);
        NeoForge.EVENT_BUS.addListener(this::mobGriefing);
        ForceLoading.setup(modEventBus);
        FTBChunks.instance = new FTBChunks();
    }

    private void entityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getEntity().level().isClientSide && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)event.getEntity(), event.getHand(), event.getEntity().blockPosition(), Protection.INTERACT_ENTITY, event.getTarget())) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    private void mobGriefing(EntityMobGriefingEvent event) {
        ClaimedChunkImpl cc;
        if (event.getEntity() instanceof EnderMan && !event.getEntity().level().isClientSide() && (cc = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos(event.getEntity()))) != null && !cc.allowMobGriefing()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

