/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.neoforge;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;

public class ForceLoading {
    static TicketController ticketController;

    static void setup(IEventBus modEventBus) {
        modEventBus.addListener(ForceLoading::registerTicketController);
    }

    private static void registerTicketController(RegisterTicketControllersEvent event) {
        ticketController = new TicketController(new ResourceLocation("ftbchunks", "default"), ForceLoading::validateLoadedChunks);
        event.register(ticketController);
    }

    private static void validateLoadedChunks(ServerLevel level, TicketHelper ticketHelper) {
        FTBChunks.LOGGER.debug("validating chunk tickets for level {}", (Object)level.dimension().location());
        ticketHelper.getEntityTickets().forEach((id, chunks) -> {
            FTBChunks.LOGGER.debug("validating {} ticking chunk tickets for {}", (Object)chunks.ticking().size(), id);
            HashSet toRemoveNon = new HashSet(chunks.nonTicking());
            if (!toRemoveNon.isEmpty()) {
                toRemoveNon.forEach(l -> ticketHelper.removeTicket(id, l.longValue(), false));
                FTBChunks.LOGGER.info("purged {} non-ticking Forge chunkloading tickets for team ID {} in dimension {}", (Object)toRemoveNon.size(), id, (Object)level.dimension().location());
            }
            HashSet toRemove = new HashSet();
            chunks.ticking().forEach(l -> {
                ClaimedChunkImpl cc = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos(level.dimension(), new ChunkPos(l)));
                if (cc == null || !cc.getTeamData().getTeamId().equals(id) || !cc.isActuallyForceLoaded()) {
                    toRemove.add(l);
                }
            });
            if (!toRemove.isEmpty()) {
                toRemove.forEach(l -> ticketHelper.removeTicket(id, l.longValue(), true));
                FTBChunks.LOGGER.info("cleaned up {} stale ticking Forge chunkloading tickets for team ID {} in dimension {}", (Object)toRemove.size(), id, (Object)level.dimension().location());
            }
        });
    }
}

