/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.EnumMap;
import net.minecraft.network.FriendlyByteBuf;

public class ChunkChangeResponsePacket
extends BaseS2CMessage {
    private final int totalChunks;
    private final int changedChunks;
    private final EnumMap<ClaimResult.StandardProblem, Integer> problems;

    public ChunkChangeResponsePacket(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems) {
        this.totalChunks = totalChunks;
        this.changedChunks = changedChunks;
        this.problems = problems;
    }

    ChunkChangeResponsePacket(FriendlyByteBuf buf) {
        this.totalChunks = buf.readVarInt();
        this.changedChunks = buf.readVarInt();
        this.problems = new EnumMap(ClaimResult.StandardProblem.class);
        int nProblems = buf.readVarInt();
        for (int i = 0; i < nProblems; ++i) {
            String name = buf.readUtf(Short.MAX_VALUE);
            int count = buf.readVarInt();
            ClaimResult.StandardProblem.forName(name).ifPresent(res -> this.problems.put((ClaimResult.StandardProblem)res, count));
        }
    }

    public MessageType getType() {
        return FTBChunksNet.CHUNK_CHANGE_RESPONSE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.totalChunks);
        buf.writeVarInt(this.changedChunks);
        buf.writeVarInt(this.problems.size());
        this.problems.forEach((res, count) -> {
            buf.writeUtf(res.getResultId());
            buf.writeVarInt(count.intValue());
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        ChunkScreen.notifyChunkUpdates(this.totalChunks, this.changedChunks, this.problems);
    }
}

