/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class PlayerVisibilityPacket
extends BaseS2CMessage {
    private final List<UUID> uuids;

    private PlayerVisibilityPacket(List<UUID> uuids) {
        this.uuids = uuids;
    }

    PlayerVisibilityPacket(FriendlyByteBuf buf) {
        this.uuids = buf.readList(FriendlyByteBuf::readUUID);
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.uuids, FriendlyByteBuf::writeUUID);
    }

    public void handle(NetworkManager.PacketContext context) {
        VisibleClientPlayers.updatePlayerList(this.uuids);
    }

    public static void syncToLevel(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PlayerVisibilityPacket.syncToPlayers(serverLevel.getPlayers(p -> true));
        }
    }

    public static void syncToAll() {
        PlayerVisibilityPacket.syncToPlayers(ClaimedChunkManagerImpl.getInstance().getMinecraftServer().getPlayerList().getPlayers());
    }

    public static void syncToPlayers(List<ServerPlayer> players) {
        if (players == null) {
            players = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().getPlayerList().getPlayers();
        }
        List playerList = players.stream().map(player -> new VisiblePlayerItem((ServerPlayer)player, ClaimedChunkManagerImpl.getInstance().getOrCreateData((ServerPlayer)player))).collect(Collectors.toList());
        boolean override = (Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get();
        for (VisiblePlayerItem recipient : playerList) {
            ArrayList<UUID> playerIds = new ArrayList<UUID>();
            for (VisiblePlayerItem other : playerList) {
                if (!override && !recipient.player.hasPermissions(2) && !other.data.canPlayerUse(recipient.player, FTBChunksProperties.LOCATION_MODE)) continue;
                playerIds.add(other.player.getUUID());
            }
            new PlayerVisibilityPacket(playerIds).sendTo(recipient.player);
        }
    }

    private record VisiblePlayerItem(ServerPlayer player, ChunkTeamDataImpl data) {
    }
}

