/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SendPlayerPositionPacket
extends BaseS2CMessage {
    private final GameProfile gameProfile;
    private final BlockPos pos;
    private final boolean valid;

    public SendPlayerPositionPacket(ServerPlayer player, BlockPos pos) {
        this.pos = pos == null ? BlockPos.ZERO : pos;
        this.valid = pos != null;
        this.gameProfile = player.getGameProfile();
    }

    SendPlayerPositionPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.valid = buf.readBoolean();
        this.gameProfile = new GameProfile(buf.readUUID(), buf.readUtf());
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_PLAYER_POSITION;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.valid);
        buf.writeUUID(this.gameProfile.getId());
        buf.writeUtf(this.gameProfile.getName());
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateTrackedPlayerPos(this.gameProfile, this.pos, this.valid);
    }
}

