/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.util.HeightUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportFromMapPacket
extends BaseC2SMessage {
    private final BlockPos pos;
    private final boolean unknownY;
    private final ResourceKey<Level> dimension;

    public TeleportFromMapPacket(BlockPos pos, boolean unknownY, ResourceKey<Level> dimension) {
        this.pos = pos;
        this.unknownY = unknownY;
        this.dimension = dimension;
    }

    TeleportFromMapPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.unknownY = buf.readBoolean();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
    }

    public MessageType getType() {
        return FTBChunksNet.TELEPORT_FROM_MAP;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.unknownY);
        buf.writeResourceLocation(this.dimension.location());
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer p = (ServerPlayer)context.getPlayer();
        ServerLevel level = p.getServer().getLevel(this.dimension);
        if (level != null && p.hasPermissions(2)) {
            int x1 = this.pos.getX();
            int y1 = this.pos.getY();
            int z1 = this.pos.getZ();
            if (this.unknownY) {
                LevelChunk chunkAccess = level.getChunkAt(this.pos);
                int topY = chunkAccess.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x1, z1);
                if (topY == chunkAccess.getMinBuildHeight() - 1) {
                    return;
                }
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x1, topY + 2, z1);
                int water = HeightUtils.getHeight((Level)level, (ChunkAccess)chunkAccess, blockPos);
                if (blockPos.getY() == -32767) {
                    blockPos.setY(70);
                } else if (water != -32767) {
                    blockPos.setY(Math.max(blockPos.getY(), water));
                }
                y1 = blockPos.getY() + 1;
            }
            p.teleportTo(level, (double)x1 + 0.5, (double)y1 + 0.1, (double)z1 + 0.5, p.getYRot(), p.getXRot());
        }
    }
}

