/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.util;

import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionFilter {
    private static WildcardedRLMatcher dimensionMatcherB = null;
    private static WildcardedRLMatcher dimensionMatcherW = null;
    private static WildcardedRLMatcher noWilderness = null;

    public static boolean isDimensionOK(ResourceKey<Level> levelKey) {
        ResourceLocation name = levelKey.location();
        return !DimensionFilter.getDimensionBlacklist().test(name) && (DimensionFilter.getDimensionWhitelist().isEmpty() || DimensionFilter.getDimensionWhitelist().test(name));
    }

    public static boolean isNoWildernessDimension(ResourceKey<Level> levelKey) {
        return DimensionFilter.getNoWildernessList().test(levelKey.location());
    }

    private static WildcardedRLMatcher getDimensionWhitelist() {
        if (dimensionMatcherW == null) {
            dimensionMatcherW = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.CLAIM_DIMENSION_WHITELIST.get());
        }
        return dimensionMatcherW;
    }

    private static WildcardedRLMatcher getDimensionBlacklist() {
        if (dimensionMatcherB == null) {
            dimensionMatcherB = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST.get());
        }
        return dimensionMatcherB;
    }

    private static WildcardedRLMatcher getNoWildernessList() {
        if (noWilderness == null) {
            noWilderness = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.NO_WILDERNESS_DIMENSIONS.get());
        }
        return noWilderness;
    }

    public static void clearMatcherCaches() {
        dimensionMatcherB = null;
        dimensionMatcherW = null;
        noWilderness = null;
    }

    private static class WildcardedRLMatcher
    implements Predicate<ResourceLocation> {
        private final Set<String> namespaces = new ObjectOpenHashSet();
        private final Set<ResourceLocation> reslocs = new ObjectOpenHashSet();

        public WildcardedRLMatcher(Collection<String> toMatch) {
            for (String s : toMatch) {
                if (s.endsWith(":*")) {
                    this.namespaces.add(s.split(":")[0]);
                    continue;
                }
                if (!ResourceLocation.isValidResourceLocation((String)s)) continue;
                this.reslocs.add(new ResourceLocation(s));
            }
        }

        public boolean isEmpty() {
            return this.reslocs.isEmpty() && this.namespaces.isEmpty();
        }

        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.reslocs.contains(resourceLocation) || this.namespaces.contains(resourceLocation.getNamespace());
        }
    }
}

