/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.libreexpfix.mixin;

import io.github.null2264.libreexpfix.mixin.EntityAccessor;
import io.github.null2264.libreexpfix.mixin.ServerGamePacketListenerAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Unique
    private void libreexpfix$sendPacket(Packet<?> packet) {
        ServerPlayer player = (ServerPlayer)this;
        ((ServerGamePacketListenerAccessor)player.connection).getConn().send(packet);
    }

    @Inject(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="TAIL")})
    private void libreexpfix$afterWorldChanged(ServerLevel origin, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        this.libreexpfix$sendPacket((Packet<?>)new ClientboundSetExperiencePacket(player.experienceProgress, player.totalExperience, player.experienceLevel));
        this.libreexpfix$sendPacket((Packet<?>)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        player.getActiveEffects().forEach(instance -> this.libreexpfix$sendPacket((Packet<?>)new ClientboundUpdateMobEffectPacket(((EntityAccessor)player).getEntityId(), instance)));
    }
}

