/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.commoble.hyperbox.CommonConfig;
import net.commoble.hyperbox.ConfigHelper;
import net.commoble.hyperbox.blocks.ApertureBlock;
import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.C2SSaveHyperboxPacket;
import net.commoble.hyperbox.blocks.HyperboxBlock;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockItem;
import net.commoble.hyperbox.blocks.HyperboxMenu;
import net.commoble.hyperbox.client.ClientProxy;
import net.commoble.hyperbox.dimension.DelayedTeleportData;
import net.commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.commoble.hyperbox.dimension.HyperboxDimension;
import net.commoble.hyperbox.dimension.HyperboxSaveData;
import net.commoble.hyperbox.dimension.ReturnPoint;
import net.commoble.hyperbox.dimension.TeleportHelper;
import net.commoble.infiniverse.api.InfiniverseAPI;
import net.commoble.infiniverse.api.UnregisterDimensionEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="hyperbox")
public class Hyperbox {
    public static final String MODID = "hyperbox";
    public static Hyperbox INSTANCE;
    public static final ResourceLocation HYPERBOX_ID;
    public static final ResourceKey<Biome> BIOME_KEY;
    public static final ResourceKey<Level> WORLD_KEY;
    public static final ResourceKey<LevelStem> DIMENSION_KEY;
    public static final ResourceKey<DimensionType> DIMENSION_TYPE_KEY;
    public final CommonConfig commonConfig;
    public final Supplier<HyperboxBlock> hyperboxBlock;
    public final Supplier<HyperboxBlock> hyperboxPreviewBlock;
    public final Supplier<ApertureBlock> apertureBlock;
    public final Supplier<Block> hyperboxWall;
    public final Supplier<BlockItem> hyperboxItem;
    public final Supplier<BlockEntityType<HyperboxBlockEntity>> hyperboxBlockEntityType;
    public final Supplier<BlockEntityType<ApertureBlockEntity>> apertureBlockEntityType;
    public final Supplier<MenuType<HyperboxMenu>> hyperboxMenuType;
    public final Supplier<Codec<HyperboxChunkGenerator>> hyperboxChunkGeneratorCodec;
    public final Supplier<AttachmentType<ReturnPoint>> returnPointAttachment;

    public Hyperbox(IEventBus modBus) {
        INSTANCE = this;
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        this.commonConfig = ConfigHelper.register(ModConfig.Type.COMMON, CommonConfig::new);
        DeferredRegister soundEvents = Hyperbox.defreg(modBus, Registries.SOUND_EVENT);
        DeferredRegister blocks = Hyperbox.defreg(modBus, Registries.BLOCK);
        DeferredRegister items = Hyperbox.defreg(modBus, Registries.ITEM);
        DeferredRegister tileEntities = Hyperbox.defreg(modBus, Registries.BLOCK_ENTITY_TYPE);
        DeferredRegister menuTypes = Hyperbox.defreg(modBus, Registries.MENU);
        DeferredRegister chunkGeneratorCodecs = Hyperbox.defreg(modBus, Registries.CHUNK_GENERATOR);
        DeferredRegister attachmentTypes = Hyperbox.defreg(modBus, NeoForgeRegistries.Keys.ATTACHMENT_TYPES);
        soundEvents.register("ambience", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(MODID, "ambience")));
        this.hyperboxBlock = blocks.register(MODID, () -> new HyperboxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_BLOCK).strength(2.0f, 1200.0f).isRedstoneConductor(HyperboxBlock::getIsNormalCube)));
        this.hyperboxPreviewBlock = blocks.register("hyperbox_preview", () -> new HyperboxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PURPUR_BLOCK).strength(2.0f, 1200.0f).isRedstoneConductor(HyperboxBlock::getIsNormalCube)));
        this.hyperboxItem = items.register(MODID, () -> new HyperboxBlockItem(this.hyperboxBlock.get(), new Item.Properties()));
        this.hyperboxBlockEntityType = tileEntities.register(MODID, () -> BlockEntityType.Builder.of(HyperboxBlockEntity::create, (Block[])new Block[]{this.hyperboxBlock.get()}).build(null));
        this.apertureBlock = blocks.register("aperture", () -> new ApertureBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARRIER).lightLevel(state -> 6).isRedstoneConductor(HyperboxBlock::getIsNormalCube)));
        this.apertureBlockEntityType = tileEntities.register("aperture", () -> BlockEntityType.Builder.of(ApertureBlockEntity::create, (Block[])new Block[]{this.apertureBlock.get()}).build(null));
        this.hyperboxWall = blocks.register("hyperbox_wall", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARRIER)));
        this.hyperboxMenuType = menuTypes.register(MODID, () -> new MenuType(HyperboxMenu::makeClientMenu, FeatureFlags.VANILLA_SET));
        this.hyperboxChunkGeneratorCodec = chunkGeneratorCodecs.register(MODID, HyperboxChunkGenerator::makeCodec);
        this.returnPointAttachment = attachmentTypes.register("return_point", () -> AttachmentType.builder(() -> ReturnPoint.EMPTY).serialize(ReturnPoint.CODEC, rp -> !rp.data().isEmpty()).copyOnDeath().comparator(ReturnPoint::equals).copyHandler((h, t) -> t).build());
        modBus.addListener(EventPriority.LOW, this::registerDelegateCapabilities);
        modBus.addListener(this::onRegisterPayloads);
        modBus.addListener(this::onBuildTabContents);
        forgeBus.addListener(this::onUnregisterDimension);
        forgeBus.addListener(EventPriority.HIGH, this::onHighPriorityWorldTick);
        if (FMLEnvironment.dist.isClient()) {
            ClientProxy.doClientModInit(modBus, forgeBus);
        }
    }

    private void registerDelegateCapabilities(RegisterCapabilitiesEvent event) {
        for (BlockCapability blockCapability : BlockCapability.getAll()) {
            this.genericallyRegisterBlockCap(event, blockCapability);
        }
    }

    private <T, C> void genericallyRegisterBlockCap(RegisterCapabilitiesEvent event, BlockCapability<T, C> blockCap) {
        event.registerBlockEntity(blockCap, this.hyperboxBlockEntityType.get(), (be, context) -> {
            Object v0;
            if (context instanceof Direction) {
                Direction direction = (Direction)context;
                v0 = be.getCapability(blockCap, direction);
            } else {
                v0 = null;
            }
            return v0;
        });
        event.registerBlockEntity(blockCap, this.apertureBlockEntityType.get(), (be, context) -> {
            Object v0;
            if (context instanceof Direction) {
                Direction direction = (Direction)context;
                v0 = be.getCapability(blockCap, direction);
            } else {
                v0 = null;
            }
            return v0;
        });
    }

    private void onRegisterPayloads(RegisterPayloadHandlerEvent event) {
        event.registrar(MODID).play(C2SSaveHyperboxPacket.ID, C2SSaveHyperboxPacket::read, C2SSaveHyperboxPacket::handle);
    }

    private void onBuildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS || event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept((ItemLike)this.hyperboxItem.get());
        }
    }

    private void onUnregisterDimension(UnregisterDimensionEvent event) {
        ServerLevel level = event.getLevel();
        MinecraftServer server = level.getServer();
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        if (level.dimensionType() == hyperboxDimensionType) {
            for (ServerPlayer player : Lists.newArrayList((Iterable)level.players())) {
                TeleportHelper.ejectPlayerFromDeadWorld(player);
            }
        }
    }

    private void onHighPriorityWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.END) {
                this.onPreServerWorldTick(serverLevel);
            } else {
                this.onPostServerWorldTick(serverLevel);
            }
        }
    }

    private void onPreServerWorldTick(ServerLevel level) {
        boolean shouldChunkBeForced;
        boolean isChunkForced;
        if (((Boolean)this.commonConfig.autoForceHyperboxChunks.get()).booleanValue() && HyperboxDimension.getDimensionType(level.getServer()) == level.dimensionType() && (isChunkForced = level.getForcedChunks().contains(HyperboxChunkGenerator.CHUNKID)) != (shouldChunkBeForced = Hyperbox.shouldHyperboxChunkBeForced(level))) {
            level.setChunkForced(HyperboxChunkGenerator.CHUNKPOS.x, HyperboxChunkGenerator.CHUNKPOS.z, shouldChunkBeForced);
        }
    }

    private void onPostServerWorldTick(@Nonnull ServerLevel level) {
        MinecraftServer server = level.getServer();
        if (Hyperbox.shouldUnloadDimension(server, level)) {
            ResourceKey key = level.dimension();
            InfiniverseAPI.get().markDimensionForUnregistration(server, key);
        }
        DelayedTeleportData.tick(level);
    }

    public static boolean shouldUnloadDimension(MinecraftServer server, @Nonnull ServerLevel targetLevel) {
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        if (hyperboxDimensionType != targetLevel.dimensionType()) {
            return false;
        }
        if ((targetLevel.getGameTime() + (long)targetLevel.hashCode()) % 20L != 0L) {
            return false;
        }
        HyperboxSaveData hyperboxData = HyperboxSaveData.getOrCreate(targetLevel);
        ResourceKey<Level> parentKey = hyperboxData.getParentWorld();
        BlockPos parentPos = hyperboxData.getParentPos();
        ServerLevel parentLevel = server.getLevel(parentKey);
        if (parentLevel == null) {
            return true;
        }
        if (!parentLevel.hasChunk(parentPos.getX() >> 4, parentPos.getZ() >> 4)) {
            return false;
        }
        BlockEntity te = parentLevel.getBlockEntity(parentPos);
        if (!(te instanceof HyperboxBlockEntity)) {
            return true;
        }
        HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)te;
        ResourceKey key = targetLevel.dimension();
        return hyperbox.getLevelKey().map(childKey -> !childKey.equals(key)).orElse(true);
    }

    private static boolean shouldHyperboxChunkBeForced(ServerLevel hyperboxLevel) {
        HyperboxSaveData data;
        ResourceKey<Level> parentKey;
        MinecraftServer server = hyperboxLevel.getServer();
        ServerLevel parentLevel = server.getLevel(parentKey = (data = HyperboxSaveData.getOrCreate(hyperboxLevel)).getParentWorld());
        if (parentLevel == null) {
            return false;
        }
        BlockPos parentPos = data.getParentPos();
        return parentLevel.hasChunkAt(parentPos);
    }

    private static <T> DeferredRegister<T> defreg(IEventBus modBus, ResourceKey<Registry<T>> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    static {
        HYPERBOX_ID = new ResourceLocation(MODID, MODID);
        BIOME_KEY = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)HYPERBOX_ID);
        WORLD_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)HYPERBOX_ID);
        DIMENSION_KEY = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)HYPERBOX_ID);
        DIMENSION_TYPE_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)HYPERBOX_ID);
    }
}

