/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.blocks.ApertureBlock;
import net.commoble.hyperbox.blocks.HyperboxBlock;
import net.commoble.hyperbox.dimension.HyperboxSaveData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.event.EventHooks;

public class ApertureBlockEntity
extends BlockEntity {
    public static final String WEAK_POWER = "weak_power";
    public static final String STRONG_POWER = "strong_power";
    public static final String COLOR = "color";
    private int weakPower = 0;
    private int strongPower = 0;
    private int color = 4863306;

    public static ApertureBlockEntity create(BlockPos pos, BlockState state) {
        return new ApertureBlockEntity(Hyperbox.INSTANCE.apertureBlockEntityType.get(), pos, state);
    }

    public ApertureBlockEntity(BlockEntityType<? extends ApertureBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public <T> T getCapability(BlockCapability<T, Direction> sidedCap, Direction side) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            BlockState parentState;
            Block parentBlock;
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.getServer();
            HyperboxSaveData data = HyperboxSaveData.getOrCreate(serverLevel);
            BlockPos parentPos = data.getParentPos();
            ResourceKey<Level> parentLevelKey = data.getParentWorld();
            ServerLevel parentLevel = server.getLevel(parentLevelKey);
            if (parentLevel != null && (parentBlock = (parentState = parentLevel.getBlockState(parentPos)).getBlock()) instanceof HyperboxBlock) {
                HyperboxBlock hyperboxBlock = (HyperboxBlock)parentBlock;
                parentLevel.registerCapabilityListener(parentPos, () -> {
                    serverLevel.invalidateCapabilities(this.getBlockPos());
                    return false;
                });
                Direction hyperboxFace = hyperboxBlock.getCurrentFacing(parentState, side.getOpposite());
                BlockPos delegatePos = parentPos.relative(hyperboxFace);
                return (T)parentLevel.getCapability(sidedCap, delegatePos, (Object)hyperboxFace.getOpposite());
            }
        }
        return null;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.setChanged();
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public int getPower(boolean strong) {
        int output = (strong ? this.strongPower : this.weakPower) - 1;
        return Mth.clamp((int)output, (int)0, (int)15);
    }

    public void updatePower(ServerLevel parentWorld, BlockPos neighborPos, BlockState neighborState, Direction directionToNeighbor) {
        int weakPower = neighborState.getSignal((BlockGetter)parentWorld, neighborPos, directionToNeighbor);
        int strongPower = neighborState.getDirectSignal((BlockGetter)parentWorld, neighborPos, directionToNeighbor);
        this.updatePower(weakPower, strongPower);
    }

    public void updatePower(int weakPower, int strongPower) {
        if (this.weakPower != weakPower || this.strongPower != strongPower) {
            this.weakPower = weakPower;
            this.strongPower = strongPower;
            BlockState thisState = this.getBlockState();
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, thisState, thisState, 3);
            Direction outputSide = (Direction)thisState.getValue((Property)ApertureBlock.FACING);
            if (EventHooks.onNeighborNotify((Level)this.level, (BlockPos)this.worldPosition, (BlockState)thisState, EnumSet.of(outputSide), (boolean)true).isCanceled()) {
                return;
            }
            BlockPos adjacentPos = this.worldPosition.relative(outputSide);
            Block thisBlock = thisState.getBlock();
            this.level.neighborChanged(adjacentPos, thisBlock, this.worldPosition);
            this.level.updateNeighborsAtExceptFromFacing(adjacentPos, thisBlock, outputSide.getOpposite());
        }
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.writeClientSensitiveData(compound);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.readClientSensitiveData(nbt);
    }

    public CompoundTag writeClientSensitiveData(CompoundTag nbt) {
        nbt.putInt(WEAK_POWER, this.weakPower);
        nbt.putInt(STRONG_POWER, this.strongPower);
        if (this.color != 4863306) {
            nbt.putInt(COLOR, this.color);
        }
        return nbt;
    }

    public void readClientSensitiveData(CompoundTag nbt) {
        this.weakPower = nbt.getInt(WEAK_POWER);
        this.strongPower = nbt.getInt(STRONG_POWER);
        if (nbt.contains(COLOR)) {
            this.color = nbt.getInt(COLOR);
        }
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = super.getUpdateTag();
        this.writeClientSensitiveData(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readClientSensitiveData(pkt.getTag());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readClientSensitiveData(tag);
    }
}

