/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import java.util.Optional;
import javax.annotation.Nullable;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.RotationHelper;
import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockItem;
import net.commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HyperboxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = BlockStateProperties.FACING;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);

    public HyperboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ATTACHMENT_DIRECTION, (Comparable)Direction.DOWN)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ATTACHMENT_DIRECTION, ROTATION});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Hyperbox.INSTANCE.hyperboxBlockEntityType.get().create(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState defaultState = this.defaultBlockState();
        BlockPos placePos = context.getClickedPos();
        Direction faceOfAdjacentBlock = context.getClickedFace();
        Direction directionTowardAdjacentBlock = faceOfAdjacentBlock.getOpposite();
        Vec3 relativeHitVec = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)placePos));
        return HyperboxBlock.getStateForPlacement(defaultState, placePos, directionTowardAdjacentBlock, relativeHitVec);
    }

    public static BlockState getStateForPlacement(BlockState defaultState, BlockPos placePos, Direction directionTowardAdjacentBlock, Vec3 relativeHitVec) {
        Direction outputDirection = RotationHelper.getOutputDirectionFromRelativeHitVec(relativeHitVec, directionTowardAdjacentBlock);
        int rotationIndex = RotationHelper.getRotationIndexForDirection(directionTowardAdjacentBlock, outputDirection);
        if (defaultState.hasProperty((Property)ATTACHMENT_DIRECTION) && defaultState.hasProperty((Property)ROTATION)) {
            return (BlockState)((BlockState)defaultState.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)directionTowardAdjacentBlock)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotationIndex));
        }
        return defaultState;
    }

    @Deprecated
    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HyperboxBlockEntity) {
                HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
                hyperbox.teleportPlayerOrOpenMenu(serverPlayer, hit.getDirection());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            Item item = stack.getItem();
            if (item instanceof HyperboxBlockItem) {
                HyperboxBlockItem hyperboxItem = (HyperboxBlockItem)item;
                hyperbox.setColor(hyperboxItem.getColor(stack));
            }
            if (!level.isClientSide) {
                if (stack.hasCustomHoverName()) {
                    hyperbox.setName(stack.getHoverName());
                }
                if (hyperbox.getLevelKey().isPresent()) {
                    hyperbox.updateDimensionAfterPlacingBlock();
                }
            }
        }
    }

    @Deprecated
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        HyperboxBlock.notifyNeighborsOfStrongSignalChange(state, level, pos);
    }

    public BlockPos getPosAdjacentToAperture(BlockState state, Direction worldSpaceFace) {
        Direction originalFace = this.getOriginalFace(state, worldSpaceFace);
        return HyperboxChunkGenerator.CENTER.relative(originalFace, 6);
    }

    @Deprecated
    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Deprecated
    public int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        Direction originalFace = this.getOriginalFace(blockState, sideOfAdjacentBlock.getOpposite());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            n = hyperbox.getPower(false, originalFace);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public int getDirectSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        Direction originalFace = this.getOriginalFace(blockState, sideOfAdjacentBlock.getOpposite());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            n = hyperbox.getPower(true, originalFace);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public void neighborChanged(BlockState thisState, Level level, BlockPos thisPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.getBlockState(fromPos), fromPos);
        super.neighborChanged(thisState, level, thisPos, fromBlock, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState thisState, LevelReader level, BlockPos thisPos, BlockPos neighborPos) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.getBlockState(neighborPos), neighborPos);
        super.onNeighborChange(thisState, level, thisPos, neighborPos);
    }

    protected void onNeighborUpdated(BlockState thisState, BlockGetter level, BlockPos thisPos, BlockState neighborState, BlockPos neighborPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos offsetToNeighbor = neighborPos.subtract((Vec3i)thisPos);
            Direction directionToNeighbor = Direction.fromDelta((int)offsetToNeighbor.getX(), (int)offsetToNeighbor.getY(), (int)offsetToNeighbor.getZ());
            if (directionToNeighbor != null) {
                this.getApertureTileEntityForFace(thisState, serverLevel, thisPos, directionToNeighbor).ifPresent(te -> {
                    te.updatePower(serverLevel, neighborPos, neighborState, directionToNeighbor);
                    te.setChanged();
                });
            }
        }
    }

    public static void notifyNeighborsOfStrongSignalChange(BlockState state, Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            world.updateNeighborsAt(pos.relative(direction), state.getBlock());
        }
    }

    public Optional<ApertureBlockEntity> getApertureTileEntityForFace(BlockState thisState, ServerLevel world, BlockPos thisPos, Direction directionToNeighbor) {
        Optional<ApertureBlockEntity> optional;
        Direction originalFace = this.getOriginalFace(thisState, directionToNeighbor);
        BlockEntity blockEntity = world.getBlockEntity(thisPos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            optional = hyperbox.getAperture(world.getServer(), originalFace);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Direction getOriginalFace(BlockState thisState, Direction worldSpaceFace) {
        Direction downRotated = (Direction)thisState.getValue((Property)ATTACHMENT_DIRECTION);
        if (downRotated == worldSpaceFace) {
            return Direction.DOWN;
        }
        if (downRotated.getOpposite() == worldSpaceFace) {
            return Direction.UP;
        }
        int rotationIndex = (Integer)thisState.getValue((Property)ROTATION);
        Direction newNorth = RotationHelper.getOutputDirection(downRotated, rotationIndex);
        if (newNorth == worldSpaceFace) {
            return Direction.NORTH;
        }
        if (newNorth.getOpposite() == worldSpaceFace) {
            return Direction.SOUTH;
        }
        Direction newEast = RotationHelper.getInputDirection(downRotated, rotationIndex, 1);
        return newEast == worldSpaceFace ? Direction.EAST : Direction.WEST;
    }

    public Direction getCurrentFacing(BlockState thisState, Direction originalFace) {
        Direction currentDown = (Direction)thisState.getValue((Property)ATTACHMENT_DIRECTION);
        int rotation = (Integer)thisState.getValue((Property)ROTATION);
        return originalFace == Direction.DOWN ? currentDown : (originalFace == Direction.UP ? currentDown.getOpposite() : RotationHelper.getInputDirection(currentDown, rotation, RotationHelper.getRotationIndexForHorizontal(originalFace)));
    }

    public static boolean getIsNormalCube(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rotation) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION) && state.hasProperty((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.getValue((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.getValue((Property)ROTATION);
            Direction newAttachmentDirection = rotation.rotate(attachmentDirection);
            int newRotationIndex = RotationHelper.getRotatedRotation(attachmentDirection, rotationIndex, rotation);
            return (BlockState)((BlockState)state.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }

    @Deprecated
    public BlockState mirror(BlockState state, Mirror mirror) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION) && state.hasProperty((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.getValue((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.getValue((Property)ROTATION);
            Direction newAttachmentDirection = mirror.mirror(attachmentDirection);
            int newRotationIndex = RotationHelper.getMirroredRotation(attachmentDirection, rotationIndex, mirror);
            return (BlockState)((BlockState)state.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }
}

