/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlock;
import net.commoble.hyperbox.blocks.HyperboxMenu;
import net.commoble.hyperbox.dimension.DelayedTeleportData;
import net.commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.commoble.hyperbox.dimension.HyperboxDimension;
import net.commoble.hyperbox.dimension.HyperboxSaveData;
import net.commoble.hyperbox.dimension.ReturnPoint;
import net.commoble.hyperbox.dimension.SpawnPointHelper;
import net.commoble.infiniverse.api.InfiniverseAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.event.EventHooks;

public class HyperboxBlockEntity
extends BlockEntity
implements Nameable {
    public static final String WORLD_KEY = "world_key";
    public static final String NAME = "CustomName";
    public static final String WEAK_POWER = "weak_power";
    public static final String STRONG_POWER = "strong_power";
    public static final String COLOR = "color";
    private Optional<ResourceKey<Level>> levelKey = Optional.empty();
    private Optional<Component> name = Optional.empty();
    private int color = 4863306;
    private int[] weakPowerDUNSWE = new int[]{0, 0, 0, 0, 0, 0};
    private int[] strongPowerDUNSWE = new int[]{0, 0, 0, 0, 0, 0};

    public static HyperboxBlockEntity create(BlockPos pos, BlockState state) {
        return new HyperboxBlockEntity(Hyperbox.INSTANCE.hyperboxBlockEntityType.get(), pos, state);
    }

    public HyperboxBlockEntity(BlockEntityType<? extends HyperboxBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void updateDimensionAfterPlacingBlock() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Direction[] dirs;
            ServerLevel thisServerLevel = (ServerLevel)level;
            MinecraftServer server = thisServerLevel.getServer();
            ServerLevel childLevel = this.getLevelIfKeySet(server);
            if (childLevel == null) {
                return;
            }
            if (((Boolean)Hyperbox.INSTANCE.commonConfig.autoForceHyperboxChunks.get()).booleanValue()) {
                childLevel.getChunk(HyperboxChunkGenerator.CHUNKPOS.x, HyperboxChunkGenerator.CHUNKPOS.z);
                childLevel.setChunkForced(HyperboxChunkGenerator.CHUNKPOS.x, HyperboxChunkGenerator.CHUNKPOS.z, true);
                childLevel.getChunkSource().updateChunkForced(HyperboxChunkGenerator.CHUNKPOS, true);
            }
            BlockState thisState = this.getBlockState();
            for (Direction dir : dirs = Direction.values()) {
                thisState.onNeighborChange((LevelReader)this.level, this.worldPosition, this.worldPosition.relative(dir));
            }
            this.level.updateNeighbourForOutputSignal(this.worldPosition, thisState.getBlock());
            HyperboxBlock.notifyNeighborsOfStrongSignalChange(thisState, (Level)childLevel, this.worldPosition);
            for (Direction sideOfChildLevel : dirs) {
                this.getAperture(server, sideOfChildLevel).ifPresent(aperture -> {
                    BlockPos aperturePos = aperture.getBlockPos();
                    aperture.getBlockState().onNeighborChange((LevelReader)aperture.getLevel(), aperturePos, aperturePos.relative(sideOfChildLevel.getOpposite()));
                });
            }
        }
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.setChanged();
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            this.level.setBlocksDirty(this.worldPosition, state, state);
        }
    }

    public int getColor() {
        return this.color;
    }

    public Optional<ResourceKey<Level>> getLevelKey() {
        return this.levelKey;
    }

    public void setLevelKey(ResourceKey<Level> key) {
        this.levelKey = Optional.ofNullable(key);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.getLevelIfKeySet(level2.getServer());
        }
        this.setChanged();
    }

    public Component getName() {
        return this.name.orElse((Component)Component.translatable((String)"block.hyperbox.hyperbox"));
    }

    @Nullable
    public Component getCustomName() {
        return this.name.orElse(null);
    }

    public void setName(@Nullable Component name) {
        this.name = Optional.ofNullable(name);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @Nullable
    public ServerLevel getLevelIfKeySet(MinecraftServer server) {
        return this.levelKey.map(key -> {
            ServerLevel targetWorld = this.getChildWorld(server, (ResourceKey<Level>)key);
            HyperboxSaveData.getOrCreate(targetWorld).setWorldPos(server, targetWorld, (ResourceKey<Level>)targetWorld.dimension(), (ResourceKey<Level>)this.level.dimension(), this.worldPosition, this.getColor());
            return targetWorld;
        }).orElse(null);
    }

    public ServerLevel getChildWorld(MinecraftServer server, ResourceKey<Level> key) {
        return InfiniverseAPI.get().getOrCreateLevel(server, key, () -> HyperboxDimension.createDimension(server));
    }

    public int getPower(boolean strong, Direction originalFace) {
        int output = (strong ? this.strongPowerDUNSWE : this.weakPowerDUNSWE)[originalFace.get3DDataValue()] - 1;
        return Mth.clamp((int)output, (int)0, (int)15);
    }

    @Nullable
    public <T> T getCapability(BlockCapability<T, Direction> sidedCap, Direction worldSpaceFace) {
        BlockState thisState = this.getBlockState();
        Block thisBlock = thisState.getBlock();
        if (thisBlock instanceof HyperboxBlock) {
            ServerLevel serverLevel;
            ServerLevel targetLevel;
            HyperboxBlock hyperboxBlock = (HyperboxBlock)thisBlock;
            Level level = this.level;
            if (level instanceof ServerLevel && (targetLevel = this.getLevelIfKeySet((serverLevel = (ServerLevel)level).getServer())) != null) {
                BlockPos targetPos = hyperboxBlock.getPosAdjacentToAperture(this.getBlockState(), worldSpaceFace);
                Direction rotatedDirection = hyperboxBlock.getOriginalFace(thisState, worldSpaceFace);
                targetLevel.registerCapabilityListener(targetPos, () -> {
                    serverLevel.invalidateCapabilities(this.getBlockPos());
                    return false;
                });
                return (T)this.level.getCapability(sidedCap, targetPos, (Object)rotatedDirection);
            }
        }
        return null;
    }

    public Optional<ApertureBlockEntity> getAperture(MinecraftServer server, Direction sideOfChildLevel) {
        Optional<ApertureBlockEntity> optional;
        BlockPos aperturePos = HyperboxChunkGenerator.CENTER.relative(sideOfChildLevel, 7);
        ServerLevel targetLevel = this.getLevelIfKeySet(server);
        if (targetLevel == null) {
            optional = Optional.empty();
        } else {
            BlockEntity blockEntity = targetLevel.getBlockEntity(aperturePos);
            if (blockEntity instanceof ApertureBlockEntity) {
                ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
                optional = Optional.of(aperture);
            } else {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    public void updatePower(int weakPower, int strongPower, Direction originalFace) {
        BlockState thisState = this.getBlockState();
        Block thisBlock = thisState.getBlock();
        if (thisBlock instanceof HyperboxBlock) {
            HyperboxBlock hyperboxBlock = (HyperboxBlock)thisBlock;
            Direction worldSpaceFace = hyperboxBlock.getCurrentFacing(thisState, originalFace);
            int originalFaceIndex = originalFace.get3DDataValue();
            int oldWeakPower = this.weakPowerDUNSWE[originalFaceIndex];
            int oldStrongPower = this.strongPowerDUNSWE[originalFaceIndex];
            if (oldWeakPower != weakPower || oldStrongPower != strongPower) {
                this.weakPowerDUNSWE[originalFaceIndex] = weakPower;
                this.strongPowerDUNSWE[originalFaceIndex] = strongPower;
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, thisState, thisState, 3);
                if (EventHooks.onNeighborNotify((Level)this.level, (BlockPos)this.worldPosition, (BlockState)thisState, EnumSet.of(originalFace), (boolean)true).isCanceled()) {
                    return;
                }
                BlockPos adjacentPos = this.worldPosition.relative(worldSpaceFace);
                this.level.neighborChanged(adjacentPos, thisBlock, this.worldPosition);
                this.level.updateNeighborsAtExceptFromFacing(adjacentPos, thisBlock, worldSpaceFace.getOpposite());
            }
        }
    }

    public void teleportPlayerOrOpenMenu(ServerPlayer serverPlayer, Direction faceActivated) {
        ServerLevel level = serverPlayer.serverLevel();
        MinecraftServer server = level.getServer();
        ServerLevel targetLevel = this.getLevelIfKeySet(server);
        if (targetLevel == null) {
            serverPlayer.openMenu(HyperboxMenu.makeServerMenu(this));
        } else {
            BlockPos pos = this.getBlockPos();
            BlockState state = this.getBlockState();
            DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
            if (hyperboxDimensionType != level.dimensionType()) {
                ReturnPoint.setReturnPoint(serverPlayer, (ResourceKey<Level>)level.dimension(), pos);
            }
            BlockPos posAdjacentToAperture = ((HyperboxBlock)state.getBlock()).getPosAdjacentToAperture(state, faceActivated);
            BlockPos spawnPoint = SpawnPointHelper.getBestSpawnPosition((BlockGetter)targetLevel, posAdjacentToAperture, HyperboxChunkGenerator.MIN_SPAWN_CORNER, HyperboxChunkGenerator.MAX_SPAWN_CORNER);
            DelayedTeleportData.getOrCreate(serverPlayer.serverLevel()).schedulePlayerTeleport((Player)serverPlayer, (ResourceKey<Level>)targetLevel.dimension(), Vec3.atCenterOf((Vec3i)spawnPoint));
        }
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.levelKey.ifPresent(key -> compound.putString(WORLD_KEY, key.location().toString()));
        this.writeClientSensitiveData(compound);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.levelKey = nbt.contains(WORLD_KEY) ? Optional.of(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(nbt.getString(WORLD_KEY)))) : Optional.empty();
        this.readClientSensitiveData(nbt);
    }

    protected CompoundTag writeClientSensitiveData(CompoundTag nbt) {
        this.name.ifPresent(theName -> nbt.putString(NAME, Component.Serializer.toJson((Component)theName)));
        if (this.color != 4863306) {
            nbt.putInt(COLOR, this.color);
        }
        nbt.putIntArray(WEAK_POWER, this.weakPowerDUNSWE);
        nbt.putIntArray(STRONG_POWER, this.strongPowerDUNSWE);
        return nbt;
    }

    protected void readClientSensitiveData(CompoundTag nbt) {
        this.name = nbt.contains(NAME) ? Optional.ofNullable(Component.Serializer.fromJson((String)nbt.getString(NAME))) : Optional.empty();
        this.color = nbt.contains(COLOR) ? nbt.getInt(COLOR) : 4863306;
        this.weakPowerDUNSWE = nbt.getIntArray(WEAK_POWER);
        this.strongPowerDUNSWE = nbt.getIntArray(STRONG_POWER);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = super.getUpdateTag();
        this.writeClientSensitiveData(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readClientSensitiveData(pkt.getTag());
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.readClientSensitiveData(nbt);
    }
}

