/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HyperboxBlockItem
extends BlockItem
implements DyeableLeatherItem {
    public static final int DEFAULT_COLOR = 4863306;
    public static final String BLOCKENTITY_KEY = "BlockEntityTag";
    public static final String DISPLAY_KEY = "display";
    public static final String COLOR_KEY = "color";

    public HyperboxBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public int getColor(ItemStack stack) {
        CompoundTag displayTag = stack.getTagElement(DISPLAY_KEY);
        if (displayTag != null && displayTag.contains(COLOR_KEY, 99)) {
            return displayTag.getInt(COLOR_KEY);
        }
        CompoundTag blockEntityTag = stack.getTagElement(BLOCKENTITY_KEY);
        if (blockEntityTag != null && blockEntityTag.contains(COLOR_KEY, 99)) {
            return blockEntityTag.getInt(COLOR_KEY);
        }
        return 4863306;
    }

    public boolean hasCustomColor(ItemStack stack) {
        CompoundTag displayTag = stack.getTagElement(DISPLAY_KEY);
        if (displayTag != null && displayTag.contains(COLOR_KEY, 99)) {
            return true;
        }
        CompoundTag blockEntityTag = stack.getTagElement(BLOCKENTITY_KEY);
        return blockEntityTag != null && blockEntityTag.contains(COLOR_KEY, 99);
    }

    public void clearColor(ItemStack stack) {
        CompoundTag blockEntityTag;
        CompoundTag displayTag = stack.getTagElement(DISPLAY_KEY);
        if (displayTag != null && displayTag.contains(COLOR_KEY)) {
            displayTag.remove(COLOR_KEY);
        }
        if ((blockEntityTag = stack.getTagElement(BLOCKENTITY_KEY)) != null && blockEntityTag.contains(COLOR_KEY)) {
            blockEntityTag.remove(COLOR_KEY);
        }
    }

    public void setColor(ItemStack stack, int color) {
        stack.getOrCreateTagElement(DISPLAY_KEY).putInt(COLOR_KEY, color);
        stack.getOrCreateTagElement(BLOCKENTITY_KEY).putInt(COLOR_KEY, color);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity;
        boolean success = super.updateCustomBlockEntityTag(pos, level, player, stack, state);
        if (success && (blockEntity = level.getBlockEntity(pos)) instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            hyperbox.setColor(HyperboxBlockItem.getColorIfHyperbox(stack));
        }
        return success;
    }

    public static int getColorIfHyperbox(ItemStack stack) {
        int n;
        Item item = stack.getItem();
        if (item instanceof HyperboxBlockItem) {
            HyperboxBlockItem hyperboxItem = (HyperboxBlockItem)item;
            n = hyperboxItem.getColor(stack);
        } else {
            n = 4863306;
        }
        return n;
    }
}

