/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.commoble.hyperbox.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BlockPreviewRenderer
extends ModelBlockRenderer {
    private static BlockPreviewRenderer INSTANCE;

    public static BlockPreviewRenderer getInstance(ModelBlockRenderer baseRenderer) {
        if (INSTANCE == null || BlockPreviewRenderer.INSTANCE.blockColors != baseRenderer.blockColors) {
            INSTANCE = new BlockPreviewRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockPreviewRenderer(ModelBlockRenderer baseRenderer) {
        super(baseRenderer.blockColors);
    }

    public static void renderBlockPreview(BlockPos pos, BlockState state, Level level, Vec3 currentRenderPos, PoseStack matrix, MultiBufferSource renderTypeBuffer) {
        matrix.pushPose();
        double offsetX = (double)pos.getX() - currentRenderPos.x();
        double offsetY = (double)pos.getY() - currentRenderPos.y();
        double offsetZ = (double)pos.getZ() - currentRenderPos.z();
        matrix.translate(offsetX, offsetY, offsetZ);
        BlockRenderDispatcher blockDispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockPreviewRenderer renderer = BlockPreviewRenderer.getInstance(blockDispatcher.getModelRenderer());
        RenderType bufferType = Sheets.translucentCullBlockSheet();
        RenderType renderType = null;
        renderer.tesselateWithoutAO((BlockAndTintGetter)level, blockDispatcher.getBlockModel(state), state, pos, matrix, renderTypeBuffer.getBuffer(bufferType), false, level.random, state.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
        matrix.popPose();
    }

    public void putQuadData(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer vertexConsumer, PoseStack.Pose pose, BakedQuad quad, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alpha = ((Double)ClientProxy.clientConfig.placementPreviewOpacity.get()).floatValue();
        if (quad.isTinted()) {
            int i = this.blockColors.getColor(state, level, pos, quad.getTintIndex());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        vertexConsumer.putBulkData(pose, quad, new float[]{tintA, tintB, tintC, tintD}, r, g, b, alpha, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true);
    }
}

