/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.client;

import javax.annotation.Nullable;
import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ColorHandlers {
    public static final int NO_TINT = 0xFFFFFF;
    public static final int BACKGROUND_TINT = 0;

    public static int getHyperboxBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (level != null && pos != null) {
                int n;
                BlockEntity te = level.getBlockEntity(pos);
                if (te instanceof HyperboxBlockEntity) {
                    HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)te;
                    n = hyperbox.getColor();
                } else {
                    n = 4863306;
                }
                return n;
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getHyperboxPreviewBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                return HyperboxBlockItem.getColorIfHyperbox(player.getMainHandItem());
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getApertureBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (level != null && pos != null) {
                int n;
                BlockEntity te = level.getBlockEntity(pos);
                if (te instanceof ApertureBlockEntity) {
                    ApertureBlockEntity aperture = (ApertureBlockEntity)te;
                    n = aperture.getColor();
                } else {
                    n = 4863306;
                }
                return n;
            }
            return 4863306;
        }
        return 0xFFFFFF;
    }

    public static int getHyperboxItemColor(ItemStack stack, int tintIndex) {
        Item item = stack.getItem();
        if (tintIndex == 0 && item instanceof HyperboxBlockItem) {
            HyperboxBlockItem hyperboxBlockItem = (HyperboxBlockItem)item;
            return hyperboxBlockItem.getColor(stack);
        }
        return 0xFFFFFF;
    }
}

