/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.dimension;

import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;

public class HyperboxSaveData
extends SavedData {
    public static final String DATA_KEY = "hyperbox";
    public static final String PARENT_WORLD_KEY = "parent_world";
    public static final String PARENT_POS_KEY = "parent_pos";
    public static final BlockPos DEFAULT_PARENT_POS = new BlockPos(0, 65, 0);
    public static final SavedData.Factory<HyperboxSaveData> FACTORY = new SavedData.Factory(HyperboxSaveData::create, HyperboxSaveData::load, null);
    private ResourceKey<Level> parentWorld = Level.OVERWORLD;
    private BlockPos parentPos = DEFAULT_PARENT_POS;

    public ResourceKey<Level> getParentWorld() {
        return this.parentWorld;
    }

    public BlockPos getParentPos() {
        return this.parentPos;
    }

    public static HyperboxSaveData getOrCreate(ServerLevel world) {
        return (HyperboxSaveData)world.getDataStorage().computeIfAbsent(FACTORY, DATA_KEY);
    }

    public static HyperboxSaveData load(CompoundTag nbt) {
        ResourceKey parentWorld = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(nbt.getString(PARENT_WORLD_KEY)));
        BlockPos parentPos = NbtUtils.readBlockPos((CompoundTag)nbt.getCompound(PARENT_POS_KEY));
        return new HyperboxSaveData((ResourceKey<Level>)parentWorld, parentPos);
    }

    public static HyperboxSaveData create() {
        return new HyperboxSaveData((ResourceKey<Level>)Level.OVERWORLD, DEFAULT_PARENT_POS);
    }

    protected HyperboxSaveData(ResourceKey<Level> parentWorld, BlockPos parentPos) {
        this.parentWorld = parentWorld;
        this.parentPos = parentPos;
    }

    public void setWorldPos(MinecraftServer server, ServerLevel thisWorld, ResourceKey<Level> thisWorldKey, ResourceKey<Level> parentWorldKey, BlockPos parentPos, int color) {
        ResourceKey<Level> oldParentWorld = this.parentWorld;
        BlockPos oldParentPos = this.parentPos;
        if (!oldParentWorld.equals(parentWorldKey) || !oldParentPos.equals((Object)parentPos)) {
            HyperboxSaveData.clearOldParent(server, thisWorldKey, oldParentWorld, oldParentPos);
        }
        this.parentWorld = parentWorldKey;
        this.parentPos = parentPos;
        for (Direction dir : Direction.values()) {
            BlockPos aperturePos = HyperboxChunkGenerator.CENTER.relative(dir, 7);
            BlockEntity blockEntity = thisWorld.getBlockEntity(aperturePos);
            if (!(blockEntity instanceof ApertureBlockEntity)) continue;
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            aperture.setColor(color);
        }
        this.setDirty();
    }

    protected static void clearOldParent(MinecraftServer server, ResourceKey<Level> thisWorldKey, ResourceKey<Level> oldParentKey, BlockPos oldParentPos) {
        BlockEntity blockEntity;
        ServerLevel oldParentWorld = server.getLevel(oldParentKey);
        if (oldParentWorld != null && (blockEntity = oldParentWorld.getBlockEntity(oldParentPos)) instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            if (hyperbox.getLevelKey().filter(thisWorldKey::equals).isPresent()) {
                oldParentWorld.removeBlock(oldParentPos, true);
            }
        }
    }

    public CompoundTag save(CompoundTag compound) {
        compound.putString(PARENT_WORLD_KEY, this.parentWorld.location().toString());
        compound.put(PARENT_POS_KEY, (Tag)NbtUtils.writeBlockPos((BlockPos)this.parentPos));
        return compound;
    }
}

