/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.dimension;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;

public class SpawnPointHelper {
    public static BlockPos getBestSpawnPosition(BlockGetter world, BlockPos target, BlockPos minSpawnCorner, BlockPos maxSpawnCorner) {
        BlockPos clampedTarget;
        BlockPos bestPos = clampedTarget = SpawnPointHelper.clamp(target, minSpawnCorner, maxSpawnCorner);
        int bestPosViability = -1;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> remaining = new LinkedList<BlockPos>();
        remaining.add(clampedTarget);
        while (remaining.size() > 0) {
            BlockPos nextPos = (BlockPos)remaining.removeFirst();
            visited.add(nextPos);
            int viability = SpawnPointHelper.getViability(world, nextPos);
            if (viability == 3) {
                return nextPos;
            }
            if (viability > bestPosViability) {
                bestPos = nextPos;
                bestPosViability = viability;
            }
            for (Direction dir : Direction.values()) {
                BlockPos nextPosToVisit = nextPos.relative(dir);
                if (visited.contains(nextPosToVisit) || !SpawnPointHelper.isPosAllowed(world, nextPosToVisit, minSpawnCorner, maxSpawnCorner)) continue;
                remaining.add(nextPosToVisit);
            }
        }
        return bestPos;
    }

    public static BlockPos clamp(BlockPos pos, BlockPos min, BlockPos max) {
        int x = Mth.clamp((int)pos.getX(), (int)min.getX(), (int)max.getX());
        int y = Mth.clamp((int)pos.getY(), (int)min.getY(), (int)max.getY());
        int z = Mth.clamp((int)pos.getZ(), (int)min.getZ(), (int)max.getZ());
        return new BlockPos(x, y, z);
    }

    public static boolean isPosAllowed(BlockGetter world, BlockPos pos, BlockPos min, BlockPos max) {
        return SpawnPointHelper.isPosWithinBounds(pos, min, max) && world.getBlockState(pos).getDestroySpeed(world, pos) >= 0.0f;
    }

    public static boolean isPosWithinBounds(BlockPos pos, BlockPos min, BlockPos max) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY() && z >= min.getZ() && z <= max.getZ();
    }

    public static int getViability(BlockGetter world, BlockPos target) {
        return SpawnPointHelper.doesBlockBlockHead(world, target.above()) ? 0 : (SpawnPointHelper.doesBlockBlockFeet(world, target) ? 1 : (SpawnPointHelper.doesBlockBlockFeet(world, target.below()) ? 3 : 2));
    }

    public static boolean doesBlockBlockHead(BlockGetter world, BlockPos pos) {
        return !world.getBlockState(pos).getShape(world, pos).isEmpty();
    }

    public static boolean doesBlockBlockFeet(BlockGetter world, BlockPos pos) {
        return !world.getBlockState(pos).getCollisionShape(world, pos).isEmpty();
    }
}

