/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.simplemagnets.MagnetItem;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.gui.MagnetContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedMagnet
extends MagnetItem {
    @Override
    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        int slot;
        if (!player.isShiftKeyDown()) {
            return super.interact(stack, player, hand, level);
        }
        int n = slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40;
        if (!level.isClientSide) {
            CommonUtils.openContainer((BaseContainer)new MagnetContainer(player, slot));
        }
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    @Override
    protected boolean canPickupItems(CompoundTag tag) {
        return !tag.contains("items") || !tag.getBoolean("items");
    }

    @Override
    protected boolean canPickupStack(CompoundTag tag, ItemStack stack) {
        boolean whitelist = tag.contains("whitelist") && tag.getBoolean("whitelist");
        boolean filterDurability = tag.contains("filterDurability") && tag.getBoolean("filterDurability");
        for (int slot = 0; slot < 9; ++slot) {
            boolean equal;
            if (!tag.contains("filter" + slot)) continue;
            ItemStack stack1 = ItemStack.of((CompoundTag)tag.getCompound("filter" + slot));
            boolean bl = equal = ItemStack.isSameItem((ItemStack)stack, (ItemStack)stack1) && (!filterDurability || ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)stack1));
            if (!equal) continue;
            return whitelist;
        }
        return !whitelist;
    }

    @Override
    protected boolean canPickupXp(CompoundTag tag) {
        return !tag.contains("xp") || !tag.getBoolean("xp");
    }

    @Override
    protected int getRangeItems(CompoundTag tag) {
        return tag.contains("itemRange") ? tag.getInt("itemRange") : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected int getRangeXp(CompoundTag tag) {
        return tag.contains("xpRange") ? tag.getInt("xpRange") : SMConfig.advancedMagnetRange.get().intValue();
    }

    @Override
    protected Component getTooltip() {
        return TextComponents.translation((String)"simplemagnets.advancedmagnet.info", (Object[])new Object[]{TextComponents.number((int)SMConfig.advancedMagnetMaxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get();
    }
}

