/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.packets.magnet.PacketItemInfo;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetMessage;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class MagnetItem
extends BaseItem {
    public MagnetItem() {
        super(ItemProperties.create().group((CreativeModeTab)SimpleMagnets.GROUP).maxStackSize(1));
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        MagnetItem.toggleMagnet(player, stack);
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    public static void toggleMagnet(Player player, ItemStack stack) {
        if (!player.level().isClientSide && stack.getItem() instanceof MagnetItem) {
            boolean active = stack.getOrCreateTag().contains("active") && stack.getOrCreateTag().getBoolean("active");
            stack.getOrCreateTag().putBoolean("active", !active);
            SimpleMagnets.CHANNEL.sendToPlayer(player, (BasePacket)new PacketToggleMagnetMessage(active));
        }
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.isSpectator()) {
            return;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (tag.contains("active") && tag.getBoolean("active")) {
            AABB area;
            int r;
            if (this.canPickupItems(tag)) {
                r = this.getRangeItems(tag);
                area = new AABB(entity.position().add((double)(-r), (double)(-r), (double)(-r)), entity.position().add((double)r, (double)r, (double)r));
                List items = level.getEntities((EntityTypeTest)EntityType.ITEM, area, item -> !(!item.isAlive() || level.isClientSide && item.tickCount <= 1 || item.thrower != null && item.thrower.equals(entity.getUUID()) && item.hasPickUpDelay() || item.getItem().isEmpty() || item.getPersistentData().contains("PreventRemoteMovement") || !this.canPickupStack(tag, item.getItem())));
                items.forEach(item -> item.setPos(entity.getX(), entity.getY(), entity.getZ()));
                if (!level.isClientSide && entity instanceof Player && CommonUtils.isModLoaded((String)"itemphysic")) {
                    items.forEach(item -> MagnetItem.playerTouch(item, (Player)entity));
                }
            }
            if (!level.isClientSide && this.canPickupXp(tag) && entity instanceof Player) {
                r = this.getRangeXp(tag);
                area = new AABB(entity.position().add((double)(-r), (double)(-r), (double)(-r)), entity.position().add((double)r, (double)r, (double)r));
                Player player = (Player)entity;
                List orbs = level.getEntitiesOfClass(ExperienceOrb.class, area);
                orbs.forEach(orb -> {
                    orb.invulnerableTime = 0;
                    player.takeXpDelay = 0;
                    orb.playerTouch(player);
                });
            }
        }
    }

    private static void playerTouch(ItemEntity itemEntity, Player player) {
        if (!itemEntity.level().isClientSide) {
            if (itemEntity.hasPickUpDelay()) {
                return;
            }
            ItemStack itemstack = itemEntity.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            int hook = EventHooks.onItemPickup((ItemEntity)itemEntity, (Player)player);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.copy();
            if (!(itemEntity.hasPickUpDelay() || itemEntity.getOwner() != null && itemEntity.lifespan - itemEntity.getAge() > 200 && !itemEntity.getOwner().equals((Object)player.getUUID()) || hook != 1 && i > 0 && !player.getInventory().add(itemstack))) {
                copy.setCount(copy.getCount() - itemstack.getCount());
                EventHooks.firePlayerItemPickupEvent((Player)player, (ItemEntity)itemEntity, (ItemStack)copy);
                player.take((Entity)itemEntity, i);
                if (itemstack.isEmpty()) {
                    itemEntity.discard();
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
                player.onItemPickup(itemEntity);
            }
        }
    }

    protected abstract boolean canPickupItems(CompoundTag var1);

    protected abstract boolean canPickupStack(CompoundTag var1, ItemStack var2);

    protected abstract boolean canPickupXp(CompoundTag var1);

    protected abstract int getRangeItems(CompoundTag var1);

    protected abstract int getRangeXp(CompoundTag var1);

    public boolean isFoil(ItemStack stack) {
        return stack.getOrCreateTag().contains("active") && stack.getOrCreateTag().getBoolean("active");
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept(this.getTooltip());
    }

    protected abstract Component getTooltip();

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        if (!e.getEntity().level().isClientSide && e.getTarget() instanceof ItemEntity && ((ItemEntity)e.getTarget()).thrower != null) {
            SimpleMagnets.CHANNEL.sendToPlayer(e.getEntity(), (BasePacket)new PacketItemInfo((ItemEntity)e.getTarget()));
        }
    }
}

