/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.gui;

import com.supermartijn642.simplemagnets.DemagnetizationCoilBlockEntity;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.gui.BaseDemagnetizationCoilContainer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FilteredDemagnetizationCoilContainer
extends BaseDemagnetizationCoilContainer {
    public FilteredDemagnetizationCoilContainer(Player player, BlockPos pos) {
        super(SimpleMagnets.filtered_demagnetization_coil_container, player, pos, 224, 206, true);
    }

    protected void addSlots(Player player, DemagnetizationCoilBlockEntity entity) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler(), i, 8 + i * 18, 90){

                public boolean mayPickup(Player player) {
                    return false;
                }
            });
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (!this.validateObjectOrClose()) {
            return;
        }
        if (slotId >= 0 && slotId < 9) {
            if (this.getCarried().isEmpty()) {
                ((DemagnetizationCoilBlockEntity)((Object)this.object)).updateFilter(slotId, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((DemagnetizationCoilBlockEntity)((Object)this.object)).updateFilter(slotId, stack);
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (!this.validateObjectOrClose()) {
            return ItemStack.EMPTY;
        }
        if (index >= 0 && index < 9) {
            if (this.getCarried().isEmpty()) {
                ((DemagnetizationCoilBlockEntity)((Object)this.object)).updateFilter(index, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((DemagnetizationCoilBlockEntity)((Object)this.object)).updateFilter(index, stack);
            }
        } else if (!this.getSlot(index).getItem().isEmpty()) {
            boolean contains = false;
            int firstEmpty = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemHandler().getStackInSlot(i);
                if (ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)this.getSlot(index).getItem())) {
                    contains = true;
                    break;
                }
                if (!stack.isEmpty() || firstEmpty != -1) continue;
                firstEmpty = i;
            }
            if (!contains && firstEmpty != -1) {
                ItemStack stack = this.getSlot(index).getItem().copy();
                stack.setCount(1);
                ((DemagnetizationCoilBlockEntity)((Object)this.object)).updateFilter(firstEmpty, stack);
            }
        }
        return ItemStack.EMPTY;
    }

    private ItemStackHandler itemHandler() {
        return new ItemStackHandler(9){

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return FilteredDemagnetizationCoilContainer.this.validateObjectOrClose() ? ((DemagnetizationCoilBlockEntity)((Object)FilteredDemagnetizationCoilContainer.this.object)).getFilter().get(slot) : ItemStack.EMPTY;
            }
        };
    }
}

