/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.gui;

import com.supermartijn642.core.gui.ItemBaseContainer;
import com.supermartijn642.simplemagnets.MagnetItem;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MagnetContainer
extends ItemBaseContainer {
    public final int slot;
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            CompoundTag tag = ((ItemStack)MagnetContainer.this.object).getTag();
            return tag != null && tag.contains("filter" + slot) ? ItemStack.of((CompoundTag)tag.getCompound("filter" + slot)) : ItemStack.EMPTY;
        }
    };

    public MagnetContainer(Player player, int slot) {
        super(SimpleMagnets.magnet_container, player, slot, stack -> stack.getItem() instanceof MagnetItem);
        this.slot = slot;
        this.addSlots();
    }

    protected void addSlots(Player player, ItemStack stack) {
        int column;
        Inventory inventory = player.getInventory();
        for (column = 0; column < 9; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, column, 8 + column * 18, 80){

                public boolean mayPickup(Player player) {
                    return false;
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)inventory, row * 9 + column2 + 9, 32 + 18 * column2, 114 + 18 * row));
            }
        }
        for (column = 0; column < 9; ++column) {
            int index = column;
            this.addSlot(new Slot((Container)inventory, index, 32 + 18 * column, 172){

                public boolean mayPickup(Player player) {
                    return this.index != MagnetContainer.this.slot;
                }
            });
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (!this.validateObjectOrClose()) {
            return;
        }
        if (clickType == ClickType.SWAP && dragType == this.slot) {
            return;
        }
        if (slotId < 9 && slotId >= 0) {
            if (this.getCarried().isEmpty()) {
                ((ItemStack)this.object).getOrCreateTag().remove("filter" + slotId);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((ItemStack)this.object).getOrCreateTag().put("filter" + slotId, (Tag)stack.save(new CompoundTag()));
            }
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!this.validateObjectOrClose()) {
            return ItemStack.EMPTY;
        }
        if (index < 9) {
            if (this.getCarried().isEmpty()) {
                ((ItemStack)this.object).getOrCreateTag().remove("filter" + index);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((ItemStack)this.object).getOrCreateTag().put("filter" + index, (Tag)stack.save(new CompoundTag()));
            }
        } else if (!this.getSlot(index).getItem().isEmpty()) {
            boolean contains = false;
            int firstEmpty = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)this.getSlot(index).getItem())) {
                    contains = true;
                    break;
                }
                if (!stack.isEmpty() || firstEmpty != -1) continue;
                firstEmpty = i;
            }
            if (!contains && firstEmpty != -1) {
                ItemStack stack = this.getSlot(index).getItem().copy();
                stack.setCount(1);
                ((ItemStack)this.object).getOrCreateTag().put("filter" + firstEmpty, (Tag)stack.save(new CompoundTag()));
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getObject(ItemStack oldObject) {
        return super.getObject(oldObject);
    }

    public boolean validateObject(ItemStack object) {
        return super.validateObject(object);
    }
}

