/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ItemBaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.gui.CheckBox;
import com.supermartijn642.simplemagnets.gui.DurabilityButton;
import com.supermartijn642.simplemagnets.gui.MagnetContainer;
import com.supermartijn642.simplemagnets.gui.PlusMinusButton;
import com.supermartijn642.simplemagnets.gui.WhitelistButton;
import com.supermartijn642.simplemagnets.packets.magnet.PacketDecreaseItemRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketDecreaseXpRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketIncreaseItemRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketIncreaseXpRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleItems;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetDurability;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetWhitelist;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleXp;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MagnetContainerScreen
extends ItemBaseContainerWidget<MagnetContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("simplemagnets", "textures/screen.png");
    private CheckBox itemCheckbox;
    private PlusMinusButton leftItemButton;
    private PlusMinusButton rightItemButton;
    private CheckBox xpCheckbox;
    private PlusMinusButton leftXpButton;
    private PlusMinusButton rightXpButton;
    private WhitelistButton whitelistButton;
    private DurabilityButton durabilityButton;
    private int itemRange = SMConfig.advancedMagnetRange.get();
    private int xpRange = SMConfig.advancedMagnetRange.get();

    public MagnetContainerScreen() {
        super(0, 0, 224, 196, (Supplier)null, null);
    }

    protected Component getNarrationMessage(ItemStack stack) {
        return TextComponents.item((Item)stack.getItem()).get();
    }

    protected ItemStack getObject(ItemStack oldObject) {
        return ((MagnetContainer)this.container).getObject(oldObject);
    }

    protected boolean validateObject(ItemStack object) {
        return ((MagnetContainer)this.container).validateObject(object);
    }

    protected void addWidgets(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        this.itemCheckbox = (CheckBox)this.addWidget((Widget)new CheckBox(11, 38, checked -> checked != false ? "simplemagnets.gui.magnet.items.on" : "simplemagnets.gui.magnet.items.off", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleItems())));
        this.itemCheckbox.update(!tag.contains("items") || !tag.getBoolean("items"));
        this.leftItemButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(54, 38, true, "simplemagnets.gui.magnet.items.decrease", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketDecreaseItemRange())));
        this.rightItemButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(88, 38, false, "simplemagnets.gui.magnet.items.increase", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketIncreaseItemRange())));
        this.xpCheckbox = (CheckBox)this.addWidget((Widget)new CheckBox(119, 38, checked -> checked != false ? "simplemagnets.gui.magnet.xp.on" : "simplemagnets.gui.magnet.xp.off", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleXp())));
        this.xpCheckbox.update(!tag.contains("xp") || !tag.getBoolean("xp"));
        this.leftXpButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(162, 38, true, "simplemagnets.gui.magnet.xp.decrease", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketDecreaseXpRange())));
        this.rightXpButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(196, 38, false, "simplemagnets.gui.magnet.xp.increase", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketIncreaseXpRange())));
        this.whitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, 78, () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleMagnetWhitelist())));
        this.whitelistButton.update(tag.contains("whitelist") && tag.getBoolean("whitelist"));
        this.durabilityButton = (DurabilityButton)this.addWidget((Widget)new DurabilityButton(197, 78, () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleMagnetDurability())));
        this.durabilityButton.update(tag.contains("filterDurability") && tag.getBoolean("filterDurability"));
    }

    protected void update(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        this.itemRange = tag.contains("itemRange") ? tag.getInt("itemRange") : SMConfig.advancedMagnetRange.get().intValue();
        this.xpRange = tag.contains("xpRange") ? tag.getInt("xpRange") : SMConfig.advancedMagnetRange.get().intValue();
        boolean items = !tag.contains("items") || !tag.getBoolean("items");
        this.itemCheckbox.update(items);
        this.leftItemButton.active = items && this.itemRange > SMConfig.advancedMagnetMinRange.get();
        this.rightItemButton.active = items && this.itemRange < SMConfig.advancedMagnetMaxRange.get();
        boolean experience = !tag.contains("xp") || !tag.getBoolean("xp");
        this.xpCheckbox.update(experience);
        this.leftXpButton.active = experience && this.xpRange > SMConfig.advancedMagnetMinRange.get();
        this.rightXpButton.active = experience && this.xpRange < SMConfig.advancedMagnetMaxRange.get();
        this.whitelistButton.update(tag.contains("whitelist") && tag.getBoolean("whitelist"));
        this.durabilityButton.update(tag.contains("filterDurability") && tag.getBoolean("filterDurability"));
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, ItemStack stack) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, mouseX, mouseY, (Object)stack);
    }

    protected void renderForeground(WidgetRenderContext context, int mouseX, int mouseY, ItemStack stack) {
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.item((Item)stack.getItem()).get(), (float)((float)this.width() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)ClientUtils.getPlayer().getInventory().getName(), (float)32.0f, (float)102.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"simplemagnets.gui.magnet.items").get(), (float)58.0f, (float)24.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"simplemagnets.gui.magnet.xp").get(), (float)166.0f, (float)24.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"simplemagnets.gui.magnet.filter").get(), (float)112.0f, (float)68.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)this.itemRange).get(), (float)79.5f, (float)43.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)this.xpRange).get(), (float)187.5f, (float)43.0f);
        super.renderForeground(context, mouseX, mouseY, (Object)stack);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, ItemStack stack) {
        if ((float)mouseX > 73.5f && (float)mouseX < 84.5f && mouseY > 41 && mouseY < 52) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"simplemagnets.gui.magnet.items.range", (Object[])new Object[]{this.itemRange}).get(), (int)mouseX, (int)mouseY);
        }
        if ((float)mouseX > 181.5f && (float)mouseX < 192.5f && mouseY > 41 && mouseY < 52) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"simplemagnets.gui.magnet.xp.range", (Object[])new Object[]{this.xpRange}).get(), (int)mouseX, (int)mouseY);
        }
        super.renderTooltips(context, mouseX, mouseY, (Object)stack);
    }
}

