/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ImplementedContainer
extends Container {
    public NonNullList<ItemStack> getItems();

    public static ImplementedContainer of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedContainer ofSize(int size) {
        return ImplementedContainer.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        this.slotChanged(slot);
        return result;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem(this.getItems(), (int)slot);
        this.slotChanged(slot);
        return itemStack;
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
        this.slotChanged(slot);
    }

    default public void clearContent() {
        this.getItems().clear();
        for (int i = 0; i < this.getItems().size(); ++i) {
            this.slotChanged(i);
        }
    }

    default public void setChanged() {
    }

    default public void slotChanged(int slot) {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    public static NonNullList<ItemStack> deserializeInventory(CompoundTag tag, int minimumSize) {
        int size = Math.max(minimumSize, tag.contains("Size", 3) ? tag.getInt("Size") : minimumSize);
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        ListTag itemTags = tag.getList("Items", 10);
        for (int i = 0; i < itemTags.size(); ++i) {
            CompoundTag itemTag = itemTags.getCompound(i);
            int slot = itemTag.getInt("Slot");
            if (slot < 0 || slot >= items.size()) continue;
            items.set(slot, (Object)ItemStack.of((CompoundTag)itemTag));
        }
        return items;
    }

    default public CompoundTag serializeInventory() {
        NonNullList<ItemStack> items = this.getItems();
        ListTag itemTags = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            ((ItemStack)items.get(i)).save(itemTag);
            itemTags.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)itemTags);
        nbt.putInt("Size", items.size());
        return nbt;
    }
}

