/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import net.blay09.mods.balm.api.container.ExtractionAwareContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SubContainer
implements Container,
ExtractionAwareContainer {
    private final Container container;
    private final int minSlot;
    private final int maxSlot;

    public SubContainer(Container container, int minSlot, int maxSlot) {
        this.container = container;
        this.minSlot = minSlot;
        this.maxSlot = maxSlot;
    }

    public int getContainerSize() {
        return this.maxSlot - this.minSlot;
    }

    public ItemStack getItem(int slot) {
        return this.containsSlot(slot) ? this.container.getItem(slot + this.minSlot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.containsSlot(slot) ? this.container.removeItem(slot + this.minSlot, amount) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.containsSlot(slot) ? this.container.removeItemNoUpdate(slot + this.minSlot) : ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (this.containsSlot(slot)) {
            this.container.setItem(slot + this.minSlot, itemStack);
        }
    }

    public void startOpen(Player player) {
        this.container.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.container.stopOpen(player);
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return this.containsSlot(slot) && this.container.canPlaceItem(slot + this.minSlot, itemStack);
    }

    public boolean isEmpty() {
        for (int i = this.minSlot; i < this.maxSlot; ++i) {
            if (this.container.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public int getMaxStackSize() {
        return this.container.getMaxStackSize();
    }

    public void setChanged() {
        this.container.setChanged();
    }

    @Deprecated(since="1.20")
    public boolean containsSlot(int slot) {
        return slot + this.minSlot < this.maxSlot;
    }

    public boolean containsOuterSlot(int slot) {
        return slot >= this.minSlot && slot < this.maxSlot;
    }

    public void clearContent() {
        for (int i = this.minSlot; i < this.maxSlot; ++i) {
            this.container.setItem(i, ItemStack.EMPTY);
        }
    }

    @Override
    public boolean canExtractItem(int slot) {
        Container container = this.container;
        if (container instanceof ExtractionAwareContainer) {
            ExtractionAwareContainer extractionAwareContainer = (ExtractionAwareContainer)container;
            return this.containsSlot(slot) && extractionAwareContainer.canExtractItem(slot + this.minSlot);
        }
        return this.containsSlot(slot);
    }
}

