/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.event;

import com.mojang.brigadier.ParseResults;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.ChunkTrackingEvent;
import net.blay09.mods.balm.api.event.CommandEvent;
import net.blay09.mods.balm.api.event.CropGrowEvent;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.neoforge.event.NeoForgeBalmEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class NeoForgeBalmCommonEvents {
    public static void registerEvents(NeoForgeBalmEvents events) {
        events.registerTickEvent(TickType.Server, TickPhase.Start, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START) {
                handler.handle(ServerLifecycleHooks.getCurrentServer());
            }
        }));
        events.registerTickEvent(TickType.Server, TickPhase.End, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END) {
                handler.handle(ServerLifecycleHooks.getCurrentServer());
            }
        }));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.Start, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START && orig.side == LogicalSide.SERVER) {
                handler.handle(orig.level);
            }
        }));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.End, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END && orig.side == LogicalSide.SERVER) {
                handler.handle(orig.level);
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.Start, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START && orig.side == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player);
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.End, handler -> NeoForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END && orig.side == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player);
            }
        }));
        events.registerEvent(ServerStartedEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            ServerStartedEvent event = new ServerStartedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ServerStoppedEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            ServerStoppedEvent event = new ServerStoppedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(UseBlockEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            UseBlockEvent event = new UseBlockEvent(orig.getEntity(), orig.getLevel(), orig.getHand(), orig.getHitVec());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(UseItemEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            UseItemEvent event = new UseItemEvent(orig.getEntity(), orig.getLevel(), orig.getHand());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerLoginEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            PlayerLoginEvent event = new PlayerLoginEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(PlayerLogoutEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            PlayerLogoutEvent event = new PlayerLogoutEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(BreakBlockEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            BlockEntity blockEntity = orig.getLevel().getBlockEntity(orig.getPos());
            BreakBlockEvent event = new BreakBlockEvent((Level)orig.getLevel(), orig.getPlayer(), orig.getPos(), orig.getState(), blockEntity);
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerRespawnEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            PlayerRespawnEvent event = new PlayerRespawnEvent((ServerPlayer)orig.getEntity(), (ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LivingFallEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            LivingFallEvent event = new LivingFallEvent(orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.getFallDamageOverride() != null) {
                orig.setDamageMultiplier(0.0f);
                event.getEntity().hurt(event.getEntity().level().damageSources().fall(), event.getFallDamageOverride().floatValue());
            }
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(LivingDamageEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            LivingDamageEvent event = new LivingDamageEvent(orig.getEntity(), orig.getSource(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            orig.setAmount(event.getDamageAmount());
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(CropGrowEvent.Pre.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt8691$temp = orig.getLevel();
            if (patt8691$temp instanceof Level) {
                Level level = (Level)patt8691$temp;
                CropGrowEvent.Pre event = new CropGrowEvent.Pre(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
                if (event.isCanceled()) {
                    orig.setResult(Event.Result.DENY);
                }
            }
        }));
        events.registerEvent(CropGrowEvent.Post.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt9296$temp = orig.getLevel();
            if (patt9296$temp instanceof Level) {
                Level level = (Level)patt9296$temp;
                CropGrowEvent.Post event = new CropGrowEvent.Post(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
            }
        }));
        events.registerEvent(ChunkTrackingEvent.Start.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Start event = new ChunkTrackingEvent.Start(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ChunkTrackingEvent.Stop.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Stop event = new ChunkTrackingEvent.Stop(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(TossItemEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            TossItemEvent event = new TossItemEvent(orig.getPlayer(), orig.getEntity().getItem());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerAttackEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            PlayerAttackEvent event = new PlayerAttackEvent(orig.getEntity(), orig.getTarget());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(LivingHealEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            LivingHealEvent event = new LivingHealEvent(orig.getEntity(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(DigSpeedEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            DigSpeedEvent event = new DigSpeedEvent(orig.getEntity(), orig.getState(), orig.getOriginalSpeed());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.getSpeedOverride() != null) {
                orig.setNewSpeed(event.getSpeedOverride().floatValue());
            }
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
        events.registerEvent(PlayerChangedDimensionEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            PlayerChangedDimensionEvent event = new PlayerChangedDimensionEvent((ServerPlayer)orig.getEntity(), (ResourceKey<Level>)orig.getFrom(), (ResourceKey<Level>)orig.getTo());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ItemCraftedEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            ItemCraftedEvent event = new ItemCraftedEvent(orig.getEntity(), orig.getCrafting(), orig.getInventory());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(CommandEvent.class, priority -> NeoForge.EVENT_BUS.addListener(NeoForgeBalmEvents.toForge(priority), orig -> {
            CommandEvent event = new CommandEvent((ParseResults<CommandSourceStack>)orig.getParseResults());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCanceled(true);
            }
        }));
    }
}

