/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.network;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.network.ClientboundMessageRegistration;
import net.blay09.mods.balm.api.network.MessageRegistration;
import net.blay09.mods.balm.api.network.ServerboundMessageRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IReplyHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoForgeBalmNetworking
implements BalmNetworking {
    private static final Logger logger = LoggerFactory.getLogger(NeoForgeBalmNetworking.class);
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private final Map<Class<?>, MessageRegistration<?>> messagesByClass = new ConcurrentHashMap();
    private static IReplyHandler replyHandler;

    private static <T> void handleServerboundPacket(ServerboundMessageRegistration<T> registration, CustomPacketPayload payload, PlayPayloadContext context) {
        Player player = context.player().orElse(null);
        if (payload instanceof WrappedPacket) {
            WrappedPacket wrappedPacket = (WrappedPacket)payload;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                registration.getHandler().accept(serverPlayer, (ServerPlayer)wrappedPacket.message());
            }
        }
    }

    private static <T> void handleClientboundPacket(ClientboundMessageRegistration<T> registration, CustomPacketPayload payload, PlayPayloadContext context) {
        if (payload instanceof WrappedPacket) {
            WrappedPacket wrappedPacket = (WrappedPacket)payload;
            registration.getHandler().accept(Balm.getProxy().getClientPlayer(), (Player)wrappedPacket.message());
        }
    }

    @Override
    public void allowClientOnly(String modId) {
        this.getRegistrations(modId).allowClientOnly();
    }

    @Override
    public void allowServerOnly(String modId) {
        this.getRegistrations(modId).allowServerOnly();
    }

    @Override
    public void openGui(Player player, MenuProvider menuProvider) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (menuProvider instanceof BalmMenuProvider) {
                BalmMenuProvider balmMenuProvider = (BalmMenuProvider)menuProvider;
                serverPlayer.openMenu(menuProvider, buf -> balmMenuProvider.writeScreenOpeningData(serverPlayer, (FriendlyByteBuf)buf));
            } else {
                serverPlayer.openMenu(menuProvider);
            }
        }
    }

    @Override
    public <T> void reply(T message) {
        if (replyHandler == null) {
            throw new IllegalStateException("No context to reply to");
        }
        MessageRegistration<T> messageRegistration = this.getMessageRegistrationOrThrow(message);
        ResourceLocation identifier = messageRegistration.getIdentifier();
        replyHandler.send((CustomPacketPayload)new WrappedPacket(identifier, message, messageRegistration.getEncodeFunc()));
    }

    @Override
    public <T> void sendTo(Player player, T message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendPacket(PacketDistributor.PLAYER.with((Object)serverPlayer), message);
        }
    }

    @Override
    public <T> void sendToTracking(ServerLevel level, BlockPos pos, T message) {
        this.sendPacket(PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(pos)), message);
    }

    @Override
    public <T> void sendToTracking(Entity entity, T message) {
        this.sendPacket(PacketDistributor.TRACKING_ENTITY.with((Object)entity), message);
    }

    @Override
    public <T> void sendToAll(MinecraftServer server, T message) {
        this.sendPacket(PacketDistributor.ALL.noArg(), message);
    }

    @Override
    public <T> void sendToServer(T message) {
        if (!Balm.getProxy().isConnectedToServer()) {
            logger.debug("Skipping message {} because we're not connected to a server", message);
            return;
        }
        this.sendPacket(PacketDistributor.SERVER.noArg(), message);
    }

    private <T> MessageRegistration<T> getMessageRegistrationOrThrow(T message) {
        MessageRegistration<?> messageRegistration = this.messagesByClass.get(message.getClass());
        if (messageRegistration == null) {
            throw new IllegalArgumentException("Cannot send message " + message.getClass() + " as it is not registered");
        }
        return messageRegistration;
    }

    @Override
    public <T> void registerClientboundPacket(ResourceLocation identifier, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encodeFunc, Function<FriendlyByteBuf, T> decodeFunc, BiConsumer<Player, T> handler) {
        ClientboundMessageRegistration<T> messageRegistration = new ClientboundMessageRegistration<T>(identifier, clazz, encodeFunc, decodeFunc, handler);
        Registrations registrations = this.getActiveRegistrations();
        this.messagesByClass.put(clazz, messageRegistration);
        registrations.messagesByIdentifier.put(identifier, messageRegistration);
    }

    @Override
    public <T> void registerServerboundPacket(ResourceLocation identifier, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encodeFunc, Function<FriendlyByteBuf, T> decodeFunc, BiConsumer<ServerPlayer, T> handler) {
        ServerboundMessageRegistration<T> messageRegistration = new ServerboundMessageRegistration<T>(identifier, clazz, encodeFunc, decodeFunc, handler);
        Registrations registrations = this.getActiveRegistrations();
        this.messagesByClass.put(clazz, messageRegistration);
        registrations.messagesByIdentifier.put(identifier, messageRegistration);
    }

    private <T> void sendPacket(PacketDistributor.PacketTarget target, T message) {
        MessageRegistration<T> messageRegistration = this.getMessageRegistrationOrThrow(message);
        target.send(new CustomPacketPayload[]{new WrappedPacket(messageRegistration.getIdentifier(), message, messageRegistration.getEncodeFunc())});
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations(modId));
    }

    @Deprecated
    private record WrappedPacket(ResourceLocation id, Object message, BiConsumer<Object, FriendlyByteBuf> encoder) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            this.encoder.accept(this.message, buf);
        }
    }

    private static class Registrations {
        private final String modId;
        private final Map<ResourceLocation, MessageRegistration<?>> messagesByIdentifier = new ConcurrentHashMap();
        private boolean optional;

        private Registrations(String modId) {
            this.modId = modId;
        }

        @SubscribeEvent
        public void registerPayloadHandlers(RegisterPayloadHandlerEvent event) {
            IPayloadRegistrar registrar = event.registrar(this.modId);
            if (this.optional) {
                registrar = registrar.optional();
            }
            for (Map.Entry<ResourceLocation, MessageRegistration<?>> entry : this.messagesByIdentifier.entrySet()) {
                ResourceLocation messageId = entry.getKey();
                MessageRegistration<?> messageRegistration = entry.getValue();
                registrar = registrar.play(messageId, buf -> {
                    Object message = messageRegistration.getDecodeFunc().apply((FriendlyByteBuf)buf);
                    return new WrappedPacket(messageId, message, messageRegistration.getEncodeFunc());
                }, it -> {
                    if (messageRegistration instanceof ServerboundMessageRegistration) {
                        ServerboundMessageRegistration serverboundMessageRegistration = (ServerboundMessageRegistration)messageRegistration;
                        it.server((payload, context) -> context.workHandler().execute(() -> {
                            replyHandler = context.replyHandler();
                            NeoForgeBalmNetworking.handleServerboundPacket(serverboundMessageRegistration, payload, context);
                            replyHandler = null;
                        }));
                    } else if (messageRegistration instanceof ClientboundMessageRegistration) {
                        ClientboundMessageRegistration clientboundMessageRegistration = (ClientboundMessageRegistration)messageRegistration;
                        it.client((payload, context) -> context.workHandler().execute(() -> {
                            replyHandler = context.replyHandler();
                            NeoForgeBalmNetworking.handleClientboundPacket(clientboundMessageRegistration, payload, context);
                            replyHandler = null;
                        }));
                    }
                });
            }
        }

        public void allowClientOnly() {
            this.optional = true;
        }

        public void allowServerOnly() {
            this.optional = true;
        }
    }
}

