/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.DisplayableBoolean;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;

public class NewKeyBindsScreen
extends KeyBindsScreen {
    private AutoCompletingEditBox<KeyBindsList.Entry> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private Button buttonNone;
    private Button buttonConflicting;
    private Button buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, (Component)ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, (Component)ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    private final Button.OnPress PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = this;
        Minecraft minecraft = Objects.requireNonNull(screen.minecraft);
        if (!this.confirmingReset.toggle()) {
            for (KeyMapping keybinding : minecraft.options.keyMappings) {
                Services.PLATFORM.setToDefault(minecraft.options, keybinding);
            }
            this.getKeyBindsList().resetMappingAndUpdateButtons();
        }
        btn.setMessage(this.confirmingReset.currentDisplay());
    };
    private final Button.OnPress PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.setMessage(this.sortOrder.getDisplay());
        this.filterKeys();
    };
    private final Button.OnPress PRESS_CONFLICTING = btn -> {
        if (this.displayMode == DisplayMode.CONFLICTING) {
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.CONFLICTING;
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_FREE = btn -> {
        this.removeWidget((GuiEventListener)this.getKeyBindsList());
        if (this.showFree) {
            this.buttonSort.active = true;
            this.buttonNone.active = true;
            this.buttonConflicting.active = true;
            this.resetButton().active = this.canReset();
            this.setKeyBindsList(this.newKeyList.get());
        } else {
            this.freeKeyList.get().recalculate();
            this.buttonSort.active = false;
            this.buttonNone.active = false;
            this.buttonConflicting.active = false;
            this.resetButton().active = false;
            this.setKeyBindsList(this.freeKeyList.get());
        }
        this.filterKeys();
        this.addRenderableWidget((GuiEventListener)this.getKeyBindsList());
        this.setFocused((GuiEventListener)this.getKeyBindsList());
        this.showFree = !this.showFree;
    };

    public NewKeyBindsScreen(Screen screen, Options settings) {
        super(screen, settings);
    }

    protected void init() {
        super.init();
        int searchX = this.getKeyBindsList().getRowWidth();
        int btnWidth = 74;
        int groupPadding = 5;
        int centerX = this.width / 2;
        int leftX = centerX - 150 - groupPadding;
        int rightX = centerX + groupPadding;
        int bottomY = this.height - 29;
        int rowSpacing = 24;
        int topRowY = bottomY - rowSpacing;
        Supplier<List> listSupplier = () -> this.getCustomList().getAllEntries();
        this.search = (AutoCompletingEditBox)this.addRenderableWidget((GuiEventListener)new AutoCompletingEditBox(this.font, centerX - searchX / 2, 22, searchX, 20, this.search, (Component)Component.translatable((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier));
        this.search.addResponder(this::filterKeys);
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.minecraft));
        this.freeKeyList = Suppliers.memoize(() -> new FreeKeysList(this, this.minecraft));
        this.removeWidget((GuiEventListener)this.getKeyBindsList());
        this.setKeyBindsList(this.showFree ? (KeyBindsList)this.freeKeyList.get() : (KeyBindsList)this.newKeyList.get());
        this.addRenderableWidget((GuiEventListener)this.getKeyBindsList());
        this.removeWidget((GuiEventListener)this.resetButton());
        this.resetButton((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.confirmingReset.currentDisplay(), (Button.OnPress)this.PRESS_RESET).bounds(leftX, bottomY, 150, 20).build()));
        this.resetButton().active = this.canReset();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, (Button.OnPress)this.PRESS_FREE).bounds(leftX, topRowY, btnWidth, 20).build());
        this.buttonSort = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.sortOrder.getDisplay(), (Button.OnPress)this.PRESS_SORT).bounds(leftX + btnWidth + 2, topRowY, btnWidth, 20).build());
        this.buttonNone = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (Button.OnPress)this.PRESS_NONE).bounds(rightX, topRowY, btnWidth, 20).build());
        this.buttonConflicting = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, (Button.OnPress)this.PRESS_CONFLICTING).bounds(rightX + btnWidth + 2, topRowY, btnWidth, 20).build());
        this.displayMode = DisplayMode.ALL;
        this.setInitialFocus((GuiEventListener)this.search);
        this.search.moveCursor(0, false);
        this.children().sort(Comparator.comparingInt(value -> value.getRectangle().top()).thenComparingInt(listener -> listener.getRectangle().left()));
    }

    public void render(GuiGraphics guiGraphics, int mxPos, int myPos, float partialTicks) {
        super.render(guiGraphics, mxPos, myPos, partialTicks);
        this.search.autoComplete().render(guiGraphics, mxPos, myPos, partialTicks);
    }

    public Button resetButton() {
        return this.getAccess().controlling$getResetButton();
    }

    public void resetButton(Button button) {
        this.getAccess().controlling$setResetButton(button);
    }

    public void filterKeys() {
        this.filterKeys(this.search.getValue());
    }

    public void filterKeys(String lastSearch) {
        this.getKeyBindsList().children().clear();
        this.getKeyBindsList().setScrollAmount(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.getKeyBindsList().children().addAll(this.getCustomList().getAllEntries());
            return;
        }
        Predicate<KeyBindsList.Entry> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        CustomList list = this.getCustomList();
        if (list instanceof NewKeyBindsList) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> this.sortOrder.sort((List<KeyBindsList.Entry>)entries);
        }
        list.children().addAll(ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.children());
    }

    public boolean mouseClicked(double xpos, double ypos, int buttonId) {
        boolean b = super.mouseClicked(xpos, ypos, buttonId);
        if (!b && this.search.isFocused() && !this.search.autoComplete().mouseClicked(xpos, ypos, buttonId)) {
            this.search.setFocused(false);
            this.clearFocus();
            b = true;
        }
        return b;
    }

    public boolean mouseScrolled(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.search.autoComplete().mouseScrolled(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.mouseScrolled(xpos, ypos, xDelta, yDelta);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (!this.search.isFocused() && this.selectedKey == null && NewKeyBindsScreen.hasControlDown() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)70)) {
            this.search.setFocused(true);
            return true;
        }
        if (this.search.isFocused() && key == 256) {
            this.search.setFocused(false);
            return true;
        }
        if (this.selectedKey != null) {
            if (key == 256) {
                Services.PLATFORM.setKey(this.options, this.selectedKey, InputConstants.UNKNOWN);
            } else {
                Services.PLATFORM.setKey(this.options, this.selectedKey, InputConstants.getKey((int)key, (int)scancode));
            }
            if (!Services.PLATFORM.isKeyCodeModifier(((AccessKeyMapping)this.selectedKey).controlling$getKey())) {
                this.selectedKey = null;
            }
            this.lastKeySelection = Util.getMillis();
            this.getKeyBindsList().resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(key, scancode, mods);
    }

    private CustomList getCustomList() {
        KeyBindsList keyBindsList = this.getKeyBindsList();
        if (keyBindsList instanceof CustomList) {
            CustomList cl = (CustomList)keyBindsList;
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList().getClass()));
    }

    private KeyBindsList getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    private void setKeyBindsList(KeyBindsList newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }

    private boolean canReset() {
        for (KeyMapping key : this.options.keyMappings) {
            if (key.isDefault()) continue;
            return true;
        }
        return false;
    }
}

