/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion;

import com.thiakil.slimylocomotion.SlimeBounceHandler;
import com.thiakil.slimylocomotion.Sounds;
import com.thiakil.slimylocomotion.item.SlimeBootsItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@Mod.EventBusSubscriber(modid="slimylocomotion")
public class GadgetEvents {
    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living == null || living.fallDistance <= 3.0f) {
            return;
        }
        boolean isPlayer = living instanceof Player;
        boolean isClient = living.level().isClientSide;
        if (isClient && !isPlayer) {
            return;
        }
        ItemStack feet = living.getItemBySlot(EquipmentSlot.FEET);
        if (!(feet.getItem() instanceof SlimeBootsItem)) {
            return;
        }
        if (living.isSuppressingBounce()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        Vec3 motion = living.getDeltaMovement();
        if (living instanceof Player) {
            double gravity = living.getAttributeValue((Attribute)NeoForgeMod.ENTITY_GRAVITY.value());
            double time = Math.sqrt((double)living.fallDistance / gravity);
            double velocity = gravity * time;
            living.setDeltaMovement(motion.x / (double)0.975f, velocity, motion.z / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living);
            living.hurtMarked = true;
        } else {
            float factor = living.fallDistance < 2.0f ? -0.7f : -0.9f;
            living.setDeltaMovement(motion.x / (double)0.975f, motion.y * (double)factor, motion.z / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living, living.getDeltaMovement());
        }
        event.setDistance(0.0f);
        if (!living.level().isClientSide) {
            living.hasImpulse = true;
        }
        living.setOnGround(false);
        event.setCanceled(true);
        living.playSound((SoundEvent)Sounds.SLIMY_BOUNCE.get(), 1.0f, 1.0f);
    }
}

