/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion;

import com.thiakil.slimylocomotion.Sounds;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public class SlimeBounceHandler {
    private static final IdentityHashMap<Entity, BounceInfo> BOUNCING_ENTITIES = new IdentityHashMap();

    private SlimeBounceHandler() {
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(SlimeBounceHandler::onLivingTick);
        NeoForge.EVENT_BUS.addListener(SlimeBounceHandler::serverStopping);
    }

    public static void addBounceHandler(LivingEntity entity) {
        SlimeBounceHandler.addBounceHandler(entity, null);
    }

    public static void addBounceHandler(LivingEntity entity, @Nullable Vec3 bounce) {
        if (entity instanceof FakePlayer) {
            return;
        }
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info == null) {
            BOUNCING_ENTITIES.put((Entity)entity, new BounceInfo(entity, bounce));
        } else if (bounce != null) {
            info.bounce = bounce;
            info.bounceTick = entity.tickCount + 1;
            Vec3 motion = entity.getDeltaMovement();
            info.lastMagSq = motion.x * motion.x + motion.z * motion.z;
            info.lastAngle = Mth.atan2((double)motion.z, (double)motion.x);
        }
    }

    private static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        BounceInfo info = BOUNCING_ENTITIES.get(entity);
        if (info != null) {
            boolean isInAir;
            if (entity.isFallFlying() || entity.isSpectator()) {
                BOUNCING_ENTITIES.remove(entity);
                return;
            }
            if (entity.tickCount == info.bounceTick) {
                if (info.bounce != null) {
                    entity.setDeltaMovement(info.bounce);
                    info.bounce = null;
                }
                info.bounceTick = 0;
            }
            boolean bl = isInAir = !entity.onGround() && !entity.isInWater() && !entity.onClimbable();
            if (isInAir && info.lastMagSq > 0.0) {
                Vec3 motion = entity.getDeltaMovement();
                double motionSq = motion.x * motion.x + motion.z * motion.z;
                if (motionSq == 0.0) {
                    if (info.stopMagTick == 0) {
                        info.stopMagTick = entity.tickCount + 5;
                    } else if (entity.tickCount > info.stopMagTick) {
                        info.lastMagSq = 0.0;
                    }
                } else if (motionSq < info.lastMagSq) {
                    info.stopMagTick = 0;
                    double boost = Math.sqrt(info.lastMagSq / motionSq) * (double)0.975f;
                    if (boost > 1.0) {
                        entity.setDeltaMovement(motion.x * boost, motion.y, motion.z * boost);
                        entity.hasImpulse = true;
                        info.lastMagSq = info.lastMagSq * (double)0.975f * (double)0.975f;
                        double newAngle = Mth.atan2((double)motion.z, (double)motion.x);
                        if (Math.abs(newAngle - info.lastAngle) > 1.0) {
                            entity.playSound((SoundEvent)Sounds.SLIMY_BOUNCE.get(), 1.0f, 1.0f);
                        }
                        info.lastAngle = newAngle;
                    } else {
                        info.lastMagSq = motionSq;
                        info.lastAngle = Mth.atan2((double)motion.z, (double)motion.x);
                    }
                }
            }
            if (info.wasInAir && !isInAir) {
                if (info.endHandler == 0) {
                    info.endHandler = entity.tickCount + 5;
                } else if (entity.tickCount > info.endHandler) {
                    BOUNCING_ENTITIES.remove(entity);
                }
            } else {
                info.endHandler = 0;
                info.wasInAir = true;
            }
        }
    }

    private static void serverStopping(ServerStoppingEvent event) {
        BOUNCING_ENTITIES.clear();
    }

    private static class BounceInfo {
        @Nullable
        private Vec3 bounce;
        private int bounceTick;
        private int stopMagTick;
        private double lastMagSq;
        private boolean wasInAir = false;
        private int endHandler = 0;
        private double lastAngle;

        public BounceInfo(LivingEntity entity, @Nullable Vec3 bounce) {
            this.bounce = bounce;
            this.bounceTick = bounce != null ? entity.tickCount + 1 : 0;
            Vec3 motion = entity.getDeltaMovement();
            this.lastMagSq = motion.x * motion.x + motion.z * motion.z;
        }
    }
}

