/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Tiers;

public enum SlimeType implements StringRepresentable
{
    EARTH(118094, 9230210, Tiers.STONE, false),
    SKY(117709, 62682, Tiers.GOLD, false),
    ICHOR(16750349, 13670400, Tiers.IRON, true, 10),
    ENDER(11488502, 11087359, Tiers.DIAMOND, false),
    BLOOD(11862273, 0xB80000, Tiers.WOOD, true);

    public static final SlimeType[] TINKER;
    public static final SlimeType[] TRUE_SLIME;
    public static final SlimeType[] LIQUID;
    public static final SlimeType[] OVERWORLD;
    public static final SlimeType[] NETHER;
    private final int color;
    private final int defaultFoliageColor;
    private final Tiers harvestTier;
    private final boolean nether;
    private final int lightLevel;

    private SlimeType(int color, int defaultFoliageColor, Tiers harvestTier, boolean nether, int lightLevel) {
        this.color = color;
        this.defaultFoliageColor = defaultFoliageColor;
        this.harvestTier = harvestTier;
        this.nether = nether;
        this.lightLevel = lightLevel;
        String name = this.getSerializedName();
    }

    private SlimeType(int color, int defaultFoliageColor, Tiers harvestTier, boolean nether) {
        this(color, defaultFoliageColor, harvestTier, nether, 0);
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.US);
    }

    static {
        TINKER = new SlimeType[]{SKY, ENDER, BLOOD, ICHOR};
        TRUE_SLIME = new SlimeType[]{EARTH, SKY, ENDER, ICHOR};
        LIQUID = new SlimeType[]{EARTH, SKY, BLOOD, ENDER};
        OVERWORLD = new SlimeType[]{EARTH, SKY, ENDER};
        NETHER = new SlimeType[]{ICHOR, BLOOD};
    }
}

