/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion.item;

import com.thiakil.slimylocomotion.SlimeType;
import com.thiakil.slimylocomotion.Sounds;
import com.thiakil.slimylocomotion.item.TooltipItem;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class BaseSlimeSlingItem
extends TooltipItem {
    private final SlimeType type;

    public BaseSlimeSlingItem(Item.Properties props, SlimeType type) {
        super(props);
        this.type = type;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == Items.SLIME_BALL;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        playerIn.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public float getForce(ItemStack stack, int timeLeft) {
        int i = this.getUseDuration(stack) - timeLeft;
        float f = (float)i / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if ((f *= 4.0f) > 6.0f) {
            f = 6.0f;
        }
        return f;
    }

    protected void onSuccess(Player player, ItemStack sling) {
        player.getCommandSenderWorld().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)Sounds.SLIME_SLING.get(), player.getSoundSource(), 1.0f, 1.0f);
        sling.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(p.getUsedItemHand()));
    }

    protected void playMissSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)Sounds.SLIME_SLING.get(), player.getSoundSource(), 1.0f, 0.5f);
    }
}

