/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion.item;

import com.thiakil.slimylocomotion.SlimeBounceHandler;
import com.thiakil.slimylocomotion.SlimeType;
import com.thiakil.slimylocomotion.item.BaseSlimeSlingItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EarthSlimeSlingItem
extends BaseSlimeSlingItem {
    public EarthSlimeSlingItem(Item.Properties props) {
        super(props, SlimeType.EARTH);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!entityLiving.onGround() || !(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        BlockHitResult mop = EarthSlimeSlingItem.getPlayerPOVHitResult((Level)worldIn, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (mop.getType() == HitResult.Type.BLOCK) {
            float f = this.getForce(stack, timeLeft);
            Vec3 vec = player.getLookAngle().normalize();
            player.push(vec.x * (double)(-f), vec.y * (double)(-f) / 3.0, vec.z * (double)(-f));
            SlimeBounceHandler.addBounceHandler((LivingEntity)player);
            if (!worldIn.isClientSide) {
                player.getCooldowns().addCooldown(stack.getItem(), 3);
                this.onSuccess(player, stack);
            }
        } else {
            this.playMissSound(player);
        }
    }
}

