/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.slimylocomotion.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.thiakil.slimylocomotion.SlimeType;
import com.thiakil.slimylocomotion.Sounds;
import com.thiakil.slimylocomotion.TranslationHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SlimeBootsItem
extends ArmorItem {
    public SlimeBootsItem(SlimeType slimeType, Item.Properties props) {
        super((ArmorMaterial)new SlimeArmorMaterial(slimeType.name().toLowerCase(Locale.ROOT) + "_slime"), ArmorItem.Type.BOOTS, props);
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot pEquipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TranslationHelper.addOptionalTooltip(stack, tooltip);
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public static class SlimeArmorMaterial
    implements ArmorMaterial {
        private final Ingredient empty_repair_material = Ingredient.of((ItemLike[])new ItemLike[]{Items.AIR});
        private final String name;

        public SlimeArmorMaterial(String slimeName) {
            this.name = slimeName;
        }

        public int getDurabilityForType(ArmorItem.Type slotIn) {
            return 0;
        }

        public int getDefenseForType(ArmorItem.Type slotIn) {
            return 0;
        }

        public int getEnchantmentValue() {
            return 0;
        }

        public SoundEvent getEquipSound() {
            return (SoundEvent)Sounds.EQUIP_SLIME.get();
        }

        public Ingredient getRepairIngredient() {
            return this.empty_repair_material;
        }

        public String getName() {
            return "slimylocomotion:" + this.name;
        }

        public float getToughness() {
            return 0.0f;
        }

        public float getKnockbackResistance() {
            return 0.0f;
        }
    }
}

