/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2crops.world;

import com.pam.pamhc2crops.setup.BlockRegistration;
import com.pam.pamhc2crops.world.ConfiguredFeatures;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PlacedFeatures {
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registries.PLACED_FEATURE, (String)"pamhc2crops");
    public static final ResourceKey<PlacedFeature> ARID_GARDEN_PLACED = PlacedFeatures.createKey("arid_garden_placed");
    public static final ResourceKey<PlacedFeature> FROST_GARDEN_PLACED = PlacedFeatures.createKey("frost_garden_placed");
    public static final ResourceKey<PlacedFeature> SHADED_GARDEN_PLACED = PlacedFeatures.createKey("shaded_garden_placed");
    public static final ResourceKey<PlacedFeature> SOGGY_GARDEN_PLACED = PlacedFeatures.createKey("soggy_garden_placed");
    public static final ResourceKey<PlacedFeature> TROPICAL_GARDEN_PLACED_JUNGLE = PlacedFeatures.createKey("tropical_garden_placed_jungle");
    public static final ResourceKey<PlacedFeature> TROPICAL_GARDEN_PLACED_OCEAN = PlacedFeatures.createKey("tropical_garden_placed_ocean");
    public static final ResourceKey<PlacedFeature> WINDY_GARDEN_PLACED_PLAINS = PlacedFeatures.createKey("windy_garden_placed_plains");
    public static final ResourceKey<PlacedFeature> WINDY_GARDEN_PLACED_SAVANNA = PlacedFeatures.createKey("windy_garden_placed_savanna");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter getter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference ARIDGARDEN = getter.getOrThrow(ConfiguredFeatures.ARID_GARDEN);
        Holder.Reference FROSTGARDEN = getter.getOrThrow(ConfiguredFeatures.FROST_GARDEN);
        Holder.Reference SHADEDGARDEN = getter.getOrThrow(ConfiguredFeatures.SHADED_GARDEN);
        Holder.Reference SOGGYGARDEN = getter.getOrThrow(ConfiguredFeatures.SOGGY_GARDEN);
        Holder.Reference TROPICALGARDENJUNGLE = getter.getOrThrow(ConfiguredFeatures.TROPICAL_GARDEN);
        Holder.Reference TROPICALGARDENOCEAN = getter.getOrThrow(ConfiguredFeatures.TROPICAL_GARDEN);
        Holder.Reference WINDYGARDENPLAINS = getter.getOrThrow(ConfiguredFeatures.WINDY_GARDEN);
        Holder.Reference WINDYGARDENSAVANNA = getter.getOrThrow(ConfiguredFeatures.WINDY_GARDEN);
        PlacedFeatures.register(context, ARID_GARDEN_PLACED, ARIDGARDEN, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, FROST_GARDEN_PLACED, FROSTGARDEN, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, SHADED_GARDEN_PLACED, SHADEDGARDEN, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, SOGGY_GARDEN_PLACED, SOGGYGARDEN, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, TROPICAL_GARDEN_PLACED_JUNGLE, TROPICALGARDENJUNGLE, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, TROPICAL_GARDEN_PLACED_OCEAN, TROPICALGARDENOCEAN, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, WINDY_GARDEN_PLACED_PLAINS, WINDYGARDENPLAINS, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
        PlacedFeatures.register(context, WINDY_GARDEN_PLACED_SAVANNA, WINDYGARDENSAVANNA, Arrays.asList(PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)BlockRegistration.aridgarden.get())), RarityFilter.onAverageOnceEvery((int)20)));
    }

    public static ResourceKey<PlacedFeature> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("pamhc2crops", pName));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(feature, modifiers));
    }
}

