/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigObject;
import java.util.function.Predicate;

public enum EntryType {
    BYTE(type -> type == Byte.TYPE),
    SHORT(type -> type == Short.TYPE),
    INTEGER(type -> type == Integer.TYPE),
    LONG(type -> type == Long.TYPE),
    FLOAT(type -> type == Float.TYPE),
    DOUBLE(type -> type == Double.TYPE),
    BOOLEAN(type -> type == Boolean.TYPE),
    STRING(type -> type == String.class),
    ENUM(Class::isEnum),
    OBJECT(type -> type.isAnnotationPresent(ConfigObject.class));

    private final Predicate<Class<?>> predicate;

    private EntryType(Predicate<Class<?>> predicate) {
        this.predicate = predicate;
    }

    public boolean test(Class<?> type) {
        return this.predicate.test(type);
    }

    public boolean isAllowedInArrays() {
        return this != OBJECT && this != ENUM;
    }

    public boolean mustBeFinal() {
        return this == OBJECT;
    }
}

