/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoriesListWidget;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoryItem;
import com.teamresourceful.resourcefulconfig.client.components.header.HeaderWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.Options;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends Screen {
    private final Screen parent;
    private final ResourcefulConfig config;
    private OptionsListWidget optionsList;

    public ConfigScreen(Screen parent, ResourcefulConfig config) {
        super(CommonComponents.EMPTY);
        this.parent = parent;
        this.config = config;
    }

    protected void rebuildWidgets() {
        OptionsListWidget oldList = this.optionsList;
        super.rebuildWidgets();
        this.optionsList.update(oldList);
    }

    protected void init() {
        int contentWidth = this.width - 20;
        int contentHeight = this.height - 20;
        int optionsWidth = contentWidth;
        LinearLayout layout = LinearLayout.vertical().spacing(10);
        HeaderWidget header = (HeaderWidget)layout.addChild((LayoutElement)new HeaderWidget(0, 0, this.width - 20, this.getFilename(), this.config));
        contentHeight -= header.getHeight() + 10;
        LinearLayout body = (LinearLayout)layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(10));
        if (!this.config.categories().isEmpty()) {
            int categoryWidth = contentWidth / 4;
            CategoriesListWidget categoryList = (CategoriesListWidget)body.addChild((LayoutElement)new CategoriesListWidget(categoryWidth, contentHeight));
            for (ResourcefulConfig value : this.config.categories().values()) {
                categoryList.add(new CategoryItem(this, value));
            }
            optionsWidth = contentWidth - categoryWidth - 10;
        }
        this.optionsList = (OptionsListWidget)body.addChild((LayoutElement)new OptionsListWidget(optionsWidth, contentHeight));
        Options.populateOptions(this.optionsList, this.config.entries(), this.config.buttons());
        layout.arrangeElements();
        layout.setPosition(10, 10);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15526633);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getChildAt(mouseX, mouseY).isEmpty()) {
            this.setFocused(null);
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Nullable
    public String getFilename() {
        Screen screen;
        if (!this.config.hasFile() && (screen = this.parent) instanceof ConfigScreen) {
            ConfigScreen screen2 = (ConfigScreen)screen;
            return screen2.getFilename();
        }
        if (!this.config.hasFile()) {
            return null;
        }
        return this.config.id();
    }

    public void removed(@Nullable Screen screen) {
        boolean shouldSave;
        boolean bl = shouldSave = screen == null || screen == this.parent && !(this.parent instanceof ConfigScreen);
        if (shouldSave) {
            this.config.save();
        }
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public Screen getParent() {
        return this.parent;
    }
}

