/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.categories;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.client.ConfigScreen;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CategoryItem
extends BaseWidget
implements ListWidget.Item {
    private static final int PADDING = 4;
    private final ConfigScreen screen;
    private final ResourcefulConfig config;

    public CategoryItem(ConfigScreen screen, ResourcefulConfig config) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        super(0, 8 + 9);
        this.screen = screen;
        this.config = config;
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHovered()) {
            graphics.blitSprite(ModSprites.BUTTON_HOVER, this.getX() + 1, this.getY(), this.getWidth() - 2, this.getHeight());
        }
        int color = this.isHovered() ? -329226 : -9276296;
        CategoryItem.renderScrollingString((GuiGraphics)graphics, (Font)Minecraft.getInstance().font, (Component)this.config.info().title().toComponent(), (int)(this.getX() + 8), (int)(this.getY() + 4), (int)(this.getX() + 8 + this.getWidth() - 16), (int)(this.getY() + this.getHeight() - 4), (int)color);
    }

    public void onClick(double d, double e) {
        Minecraft.getInstance().setScreen((Screen)new ConfigScreen(this.screen, this.config));
    }

    @Override
    public void setItemWidth(int width) {
        this.setWidth(width);
    }
}

