/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.FamiliarChestedHorseModel;
import fuzs.betteranimationscollection.client.model.FamiliarHorseModel;
import fuzs.betteranimationscollection.mixin.client.accessor.HorseArmorLayerAccessor;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.world.entity.animal.horse.Horse;

public class FamiliarHorseElement
extends ModelElement {
    private final ModelLayerLocation animatedHorse;
    private final ModelLayerLocation animatedHorseArmor;
    private final ModelLayerLocation animatedChestedHorse;

    public FamiliarHorseElement(BiFunction<String, String, ModelLayerLocation> factory) {
        this.animatedHorse = factory.apply("animated_horse", "main");
        this.animatedHorseArmor = factory.apply("animated_horse_armor", "main");
        this.animatedChestedHorse = factory.apply("animated_chested_horse", "main");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Makes horses more lively again, just like they used to be in older versions.", "Does this by adding back their mouth and knees while staying true to the vanilla model style."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(HorseModel.class, () -> new FamiliarHorseModel(bakery.bakeLayer(this.animatedHorse)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof HorseArmorLayer) {
                ((HorseArmorLayerAccessor)renderLayer).setModel(new FamiliarHorseModel<Horse>(bakery.bakeLayer(this.animatedHorseArmor)));
            }
            return Optional.empty();
        });
        context.registerAnimatedModel(ChestedHorseModel.class, () -> new FamiliarChestedHorseModel(bakery.bakeLayer(this.animatedChestedHorse)));
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> context) {
        context.accept(this.animatedHorse, () -> LayerDefinition.create((MeshDefinition)FamiliarHorseModel.createAnimatedBodyMesh(CubeDeformation.NONE), (int)64, (int)64));
        context.accept(this.animatedHorseArmor, () -> LayerDefinition.create((MeshDefinition)FamiliarHorseModel.createAnimatedBodyMesh(new CubeDeformation(0.1f)), (int)64, (int)64));
        context.accept(this.animatedChestedHorse, FamiliarChestedHorseModel::createAnimatedBodyLayer);
    }
}

