/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RemoteSoundHandler {
    public static final RemoteSoundHandler INSTANCE = new RemoteSoundHandler();
    private static final int MAX_SOUND_ANIMATION_TIME = 20;
    private final Map<ResourceLocation, Class<? extends Mob>> ambientSounds = Maps.newConcurrentMap();
    private final Set<Class<? extends Mob>> noisyEntities = Sets.newConcurrentHashSet();
    private final Set<Class<? extends Mob>> attackableEntities = Sets.newHashSet();
    private final SoundDetectionListener soundListener = new SoundDetectionListener();

    public EventResult onLivingTick(LivingEntity entity) {
        this.soundListener.ensureInitialized();
        if (!entity.level().isClientSide || !(entity instanceof Mob)) {
            return EventResult.PASS;
        }
        Mob mob = (Mob)entity;
        Stream.concat(this.noisyEntities.stream(), this.attackableEntities.stream()).forEach(clazz -> {
            if (clazz.isAssignableFrom(entity.getClass()) && mob.ambientSoundTime >= 0) {
                mob.ambientSoundTime = -mob.getAmbientSoundInterval() + 20;
            }
        });
        for (Class<? extends Mob> clazz2 : this.attackableEntities) {
            if (!clazz2.isAssignableFrom(entity.getClass()) || mob.hurtDuration <= 0 || mob.hurtTime != mob.hurtDuration) continue;
            mob.ambientSoundTime = -mob.getAmbientSoundInterval();
        }
        return EventResult.PASS;
    }

    public void addAmbientSounds(Class<? extends Mob> entityClazz, Collection<SoundEvent> soundEvents) {
        this.noisyEntities.add(entityClazz);
        for (SoundEvent soundEvent : soundEvents) {
            this.ambientSounds.put(soundEvent.getLocation(), entityClazz);
        }
    }

    public void removeAmbientSounds(Class<? extends Mob> entityClazz) {
        this.ambientSounds.values().removeIf(clazz -> clazz.equals(entityClazz));
    }

    public void addAttackableEntity(Class<? extends Mob> entityClazz) {
        this.attackableEntities.add(entityClazz);
    }

    private class SoundDetectionListener
    implements SoundEventListener {
        private boolean initialized;

        private SoundDetectionListener() {
        }

        public void ensureInitialized() {
            if (!this.initialized) {
                Minecraft.getInstance().getSoundManager().addListener((SoundEventListener)this);
                this.initialized = true;
            }
        }

        public void onPlaySound(SoundInstance soundIn, WeighedSoundEvents accessor, float range) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            Class<? extends Mob> entityClazz = RemoteSoundHandler.this.ambientSounds.get(soundIn.getLocation());
            if (entityClazz != null) {
                Vec3 center = new Vec3(soundIn.getX() + 0.0625, soundIn.getY() + 0.0625, soundIn.getZ() + 0.0625);
                double soundDetectionRange = ((ClientConfig)BetterAnimationsCollection.CONFIG.get(ClientConfig.class)).soundDetectionRange;
                AABB axisAlignedBB = new AABB(center, center).inflate(soundDetectionRange + 0.0625);
                List entities = level.getEntitiesOfClass(entityClazz, axisAlignedBB);
                entities.stream().min((o1, o2) -> (int)Math.signum(o1.position().distanceTo(center) - o2.position().distanceTo(center))).ifPresent(entity -> {
                    entity.ambientSoundTime = -entity.getAmbientSoundInterval();
                });
            }
        }
    }
}

