/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class FamiliarHorseModel<T extends AbstractHorse>
extends HorseModel<T> {
    private final ModelPart headParts;
    private final ModelPart upperMouth;
    private final ModelPart lowerMouth;
    private final ModelPart mouthSaddleWrap;
    private final ModelPart lowerMouthSaddleWrap;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindShin;
    private final ModelPart rightHindShin;
    private final ModelPart leftFrontShin;
    private final ModelPart rightFrontShin;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftHindBabyShin;
    private final ModelPart rightHindBabyShin;
    private final ModelPart leftFrontBabyShin;
    private final ModelPart rightFrontBabyShin;
    private final ModelPart rightSaddleMouth;
    private final ModelPart leftSaddleMouth;

    public FamiliarHorseModel(ModelPart modelPart) {
        super(modelPart);
        this.headParts = modelPart.getChild("head_parts");
        this.upperMouth = this.headParts.getChild("upper_mouth");
        this.lowerMouth = this.headParts.getChild("lower_mouth");
        this.rightHindLeg = modelPart.getChild("right_hind_leg");
        this.leftHindLeg = modelPart.getChild("left_hind_leg");
        this.rightFrontLeg = modelPart.getChild("right_front_leg");
        this.leftFrontLeg = modelPart.getChild("left_front_leg");
        this.rightHindShin = modelPart.getChild("right_hind_shin");
        this.leftHindShin = modelPart.getChild("left_hind_shin");
        this.rightFrontShin = modelPart.getChild("right_front_shin");
        this.leftFrontShin = modelPart.getChild("left_front_shin");
        this.rightHindBabyLeg = modelPart.getChild("right_hind_baby_leg");
        this.leftHindBabyLeg = modelPart.getChild("left_hind_baby_leg");
        this.rightFrontBabyLeg = modelPart.getChild("right_front_baby_leg");
        this.leftFrontBabyLeg = modelPart.getChild("left_front_baby_leg");
        this.rightHindBabyShin = modelPart.getChild("right_hind_baby_shin");
        this.leftHindBabyShin = modelPart.getChild("left_hind_baby_shin");
        this.rightFrontBabyShin = modelPart.getChild("right_front_baby_shin");
        this.leftFrontBabyShin = modelPart.getChild("left_front_baby_shin");
        this.leftSaddleMouth = this.headParts.getChild("left_saddle_mouth");
        this.rightSaddleMouth = this.headParts.getChild("right_saddle_mouth");
        this.mouthSaddleWrap = this.headParts.getChild("mouth_saddle_wrap");
        this.lowerMouthSaddleWrap = this.headParts.getChild("lower_mouth_saddle_wrap");
    }

    public static MeshDefinition createAnimatedBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = HorseModel.createBodyMesh((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("head_parts", CubeListBuilder.create().texOffs(0, 35).addBox(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.rotation((float)0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -11.0f, -7.0f, 4.0f, 3.0f, 5.0f, cubeDeformation), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("lower_mouth", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -8.0f, -7.0f, 4.0f, 2.0f, 5.0f, cubeDeformation), PartPose.ZERO);
        partDefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("left_hind_shin", CubeListBuilder.create().texOffs(48, 26).mirror().addBox(-3.0f, 0.99f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)17.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("right_hind_shin", CubeListBuilder.create().texOffs(48, 26).addBox(-1.0f, 0.99f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)17.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("left_front_shin", CubeListBuilder.create().texOffs(48, 26).mirror().addBox(-3.0f, 0.99f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)9.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("right_front_shin", CubeListBuilder.create().texOffs(48, 26).addBox(-1.0f, 0.99f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)9.0f, (float)-12.0f));
        CubeDeformation cubeDeformation2 = cubeDeformation.extend(0.0f, 1.0f, 0.0f);
        partDefinition.addOrReplaceChild("left_hind_baby_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, 0.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.offset((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("right_hind_baby_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, 0.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.offset((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("left_front_baby_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, 0.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.offset((float)4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("right_front_baby_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, 0.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.offset((float)-4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("left_hind_baby_shin", CubeListBuilder.create().texOffs(48, 26).mirror().addBox(-3.0f, 4.01f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.offset((float)4.0f, (float)17.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("right_hind_baby_shin", CubeListBuilder.create().texOffs(48, 26).addBox(-1.0f, 4.01f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.offset((float)-4.0f, (float)17.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("left_front_baby_shin", CubeListBuilder.create().texOffs(48, 26).mirror().addBox(-3.0f, 4.01f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.offset((float)4.0f, (float)9.0f, (float)-12.0f));
        partDefinition.addOrReplaceChild("right_front_baby_shin", CubeListBuilder.create().texOffs(48, 26).addBox(-1.0f, 4.01f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.offset((float)-4.0f, (float)9.0f, (float)-12.0f));
        partDefinition3.addOrReplaceChild("left_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(2.0f, -9.0f, -5.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("right_saddle_mouth", CubeListBuilder.create().texOffs(29, 5).addBox(-3.0f, -9.0f, -5.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        CubeDeformation cubeDeformation1 = new CubeDeformation(0.2f);
        partDefinition3.addOrReplaceChild("head_saddle", CubeListBuilder.create().texOffs(1, 1).addBox(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, cubeDeformation1), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("mouth_saddle_wrap", CubeListBuilder.create().texOffs(19, 0).addBox(-2.0f, -11.0f, -4.0f, 4.0f, 3.0f, 2.0f, cubeDeformation1), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("lower_mouth_saddle_wrap", CubeListBuilder.create().texOffs(19, 0).addBox(-2.0f, -8.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubeDeformation1), PartPose.ZERO);
        return meshDefinition;
    }

    protected Iterable<ModelPart> bodyParts() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.bodyParts().spliterator(), false), Stream.of(this.leftHindShin, this.rightHindShin, this.leftFrontShin, this.rightFrontShin, this.leftHindBabyShin, this.rightHindBabyShin, this.leftFrontBabyShin, this.rightFrontBabyShin)).collect(ImmutableList.toImmutableList());
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.lowerMouthSaddleWrap.visible = entityIn.isSaddled();
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.prepareMobModel(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        float f = Mth.rotLerp((float)((AbstractHorse)entitylivingbaseIn).yBodyRotO, (float)((AbstractHorse)entitylivingbaseIn).yBodyRot, (float)partialTickTime);
        float f1 = Mth.rotLerp((float)((AbstractHorse)entitylivingbaseIn).yHeadRotO, (float)((AbstractHorse)entitylivingbaseIn).yHeadRot, (float)partialTickTime);
        float f2 = Mth.lerp((float)partialTickTime, (float)((AbstractHorse)entitylivingbaseIn).xRotO, (float)entitylivingbaseIn.getXRot());
        float f3 = f1 - f;
        float f4 = f2 * ((float)Math.PI / 180);
        f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
        if (limbSwingAmount > 0.2f) {
            f4 += Mth.cos((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        float f5 = entitylivingbaseIn.getEatAnim(partialTickTime);
        float f6 = entitylivingbaseIn.getStandAnim(partialTickTime);
        float f7 = 1.0f - f6;
        float f8 = entitylivingbaseIn.getMouthAnim(partialTickTime);
        float f9 = (float)((AbstractHorse)entitylivingbaseIn).tickCount + partialTickTime;
        this.headParts.y = 4.0f;
        this.headParts.z = -12.0f;
        this.headParts.xRot = 0.5235988f + f4;
        this.headParts.yRot = f3 * ((float)Math.PI / 180);
        float f10 = entitylivingbaseIn.isInWater() ? 0.2f : 1.0f;
        float f11 = Mth.cos((float)(f10 * limbSwing * 0.6662f + (float)Math.PI));
        float f12 = f11 * 1.8f * limbSwingAmount;
        float f13 = f11 * 1.4f * limbSwingAmount;
        this.headParts.xRot = f6 * (0.2617994f + f4) + f5 * 2.1816616f + (1.0f - Math.max(f6, f5)) * this.headParts.xRot;
        this.headParts.yRot = f6 * f3 * ((float)Math.PI / 180) + (1.0f - Math.max(f6, f5)) * this.headParts.yRot;
        this.headParts.y = f6 * -4.0f + f5 * 11.0f + (1.0f - Math.max(f6, f5)) * this.headParts.y;
        this.headParts.z = f6 * -4.0f + f5 * -12.0f + (1.0f - Math.max(f6, f5)) * this.headParts.z;
        this.rightSaddleMouth.y = 0.02f;
        this.leftSaddleMouth.y = 0.02f;
        this.mouthSaddleWrap.y = 0.02f;
        this.upperMouth.y = 0.02f;
        this.lowerMouthSaddleWrap.y = 0.0f;
        this.lowerMouth.y = 0.0f;
        this.leftSaddleMouth.z = this.rightSaddleMouth.z = 0.02f - f8;
        this.mouthSaddleWrap.z = this.rightSaddleMouth.z;
        this.upperMouth.z = this.rightSaddleMouth.z;
        this.lowerMouth.z = this.lowerMouthSaddleWrap.z = f8;
        this.leftSaddleMouth.xRot = this.rightSaddleMouth.xRot = -0.09424778f * f8;
        this.mouthSaddleWrap.xRot = this.rightSaddleMouth.xRot;
        this.upperMouth.xRot = this.rightSaddleMouth.xRot;
        this.lowerMouth.xRot = this.lowerMouthSaddleWrap.xRot = 0.15707964f * f8;
        this.rightSaddleMouth.yRot = 0.0f;
        this.leftSaddleMouth.yRot = 0.0f;
        this.mouthSaddleWrap.yRot = 0.0f;
        this.upperMouth.yRot = 0.0f;
        this.lowerMouthSaddleWrap.yRot = 0.0f;
        this.lowerMouth.yRot = 0.0f;
        float f14 = 0.2617994f * f6;
        float f15 = Mth.cos((float)(f9 * 0.6f + (float)Math.PI));
        this.rightFrontLeg.y = 2.0f * f6 + 14.0f * f7;
        this.rightFrontLeg.z = -6.0f * f6 - 10.0f * f7;
        this.leftFrontLeg.y = this.rightFrontLeg.y;
        this.leftFrontLeg.z = this.rightFrontLeg.z;
        this.rightHindShin.y = this.rightHindLeg.y + Mth.sin((float)(1.5707964f + f14 + f7 * -f12)) * 3.0f;
        this.rightHindShin.z = this.rightHindLeg.z + Mth.cos((float)(-1.5707964f + f14 + f7 * -f12)) * 3.0f;
        this.leftHindShin.y = this.leftHindLeg.y + Mth.sin((float)(1.5707964f + f14 + f7 * f12)) * 3.0f;
        this.leftHindShin.z = this.leftHindLeg.z + Mth.cos((float)(-1.5707964f + f14 + f7 * f12)) * 3.0f;
        float f16 = (-1.0471976f + f15) * f6 + f12 * f7;
        float f17 = (-1.0471976f - f15) * f6 - f12 * f7;
        this.rightFrontShin.y = this.rightFrontLeg.y + Mth.sin((float)(1.5707964f + f16)) * 3.0f;
        this.rightFrontShin.z = this.rightFrontLeg.z + Mth.cos((float)(-1.5707964f + f16)) * 3.0f;
        this.leftFrontShin.y = this.leftFrontLeg.y + Mth.sin((float)(1.5707964f + f17)) * 3.0f;
        this.leftFrontShin.z = this.leftFrontLeg.z + Mth.cos((float)(-1.5707964f + f17)) * 3.0f;
        this.rightHindLeg.xRot = f14 - f12 * f7;
        this.rightHindShin.xRot = -0.08726646f * f6 + (-f13 - Math.max(0.0f, f13)) * f7;
        this.leftHindLeg.xRot = f14 + f12 * f7;
        this.leftHindShin.xRot = -0.08726646f * f6 + (f13 - Math.max(0.0f, -f13)) * f7;
        this.rightFrontLeg.xRot = f16;
        this.rightFrontShin.xRot = (this.rightFrontLeg.xRot + (float)Math.PI * Math.max(0.0f, 0.2f + f15 * 0.2f)) * f6 + (f13 + Math.max(0.0f, f13)) * f7;
        this.leftFrontLeg.xRot = f17;
        this.leftFrontShin.xRot = (this.leftFrontLeg.xRot + (float)Math.PI * Math.max(0.0f, 0.2f - f15 * 0.2f)) * f6 + (-f13 + Math.max(0.0f, -f13)) * f7;
        this.copyBabyModelAngles();
        this.setBabyModelVisibility();
    }

    private void copyBabyModelAngles() {
        this.rightHindBabyLeg.y = this.rightHindLeg.y;
        this.rightHindBabyLeg.z = this.rightHindLeg.z;
        this.rightHindBabyLeg.xRot = this.rightHindLeg.xRot;
        this.leftHindBabyLeg.y = this.leftHindLeg.y;
        this.leftHindBabyLeg.z = this.leftHindLeg.z;
        this.leftHindBabyLeg.xRot = this.leftHindLeg.xRot;
        this.rightFrontBabyLeg.y = this.rightFrontLeg.y;
        this.rightFrontBabyLeg.z = this.rightFrontLeg.z;
        this.rightFrontBabyLeg.xRot = this.rightFrontLeg.xRot;
        this.leftFrontBabyLeg.y = this.leftFrontLeg.y;
        this.leftFrontBabyLeg.z = this.leftFrontLeg.z;
        this.leftFrontBabyLeg.xRot = this.leftFrontLeg.xRot;
        this.rightHindBabyShin.y = this.rightHindShin.y;
        this.rightHindBabyShin.z = this.rightHindShin.z;
        this.rightHindBabyShin.xRot = this.rightHindShin.xRot;
        this.leftHindBabyShin.y = this.leftHindShin.y;
        this.leftHindBabyShin.z = this.leftHindShin.z;
        this.leftHindBabyShin.xRot = this.leftHindShin.xRot;
        this.rightFrontBabyShin.y = this.rightFrontShin.y;
        this.rightFrontBabyShin.z = this.rightFrontShin.z;
        this.rightFrontBabyShin.xRot = this.rightFrontShin.xRot;
        this.leftFrontBabyShin.y = this.leftFrontShin.y;
        this.leftFrontBabyShin.z = this.leftFrontShin.z;
        this.leftFrontBabyShin.xRot = this.leftFrontShin.xRot;
    }

    private void setBabyModelVisibility() {
        this.rightHindLeg.visible = !this.young;
        this.leftHindLeg.visible = !this.young;
        this.rightFrontLeg.visible = !this.young;
        this.leftFrontLeg.visible = !this.young;
        this.rightHindShin.visible = !this.young;
        this.leftHindShin.visible = !this.young;
        this.rightFrontShin.visible = !this.young;
        this.leftFrontShin.visible = !this.young;
        this.rightHindBabyLeg.visible = this.young;
        this.leftHindBabyLeg.visible = this.young;
        this.rightFrontBabyLeg.visible = this.young;
        this.leftFrontBabyLeg.visible = this.young;
        this.rightHindBabyShin.visible = this.young;
        this.leftHindBabyShin.visible = this.young;
        this.rightFrontBabyShin.visible = this.young;
        this.leftFrontBabyShin.visible = this.young;
    }
}

