/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.FlailingEndermanElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class FlailingEndermanModel<T extends LivingEntity>
extends EndermanModel<T> {
    public static final int ENDERMAN_ARM_LENGTH = 12;
    private final ModelPart[] rightArmParts = new ModelPart[12];
    private final ModelPart[] leftArmParts = new ModelPart[12];

    public FlailingEndermanModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightArm = modelPart.getChild("right_arm");
        for (int i = 0; i < this.rightArmParts.length; ++i) {
            rightArm = this.rightArmParts[i] = rightArm.getChild("right_arm_part" + i);
        }
        ModelPart leftArm = modelPart.getChild("left_arm");
        for (int i = 0; i < this.leftArmParts.length; ++i) {
            leftArm = this.leftArmParts[i] = leftArm.getChild("left_arm_part" + i);
        }
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = EndermanModel.createBodyLayer();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-3.0f, (float)-13.0f, (float)0.0f));
        for (int i = 0; i < 12; ++i) {
            partDefinition1 = partDefinition1.addOrReplaceChild("right_arm_part" + i, CubeListBuilder.create().texOffs(56, 2 + i * 2).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)(i == 0 ? 1.0f : 2.0f), (float)0.0f));
        }
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, true), PartPose.offset((float)5.0f, (float)-13.0f, (float)0.0f));
        for (int i = 0; i < 12; ++i) {
            partDefinition2 = partDefinition2.addOrReplaceChild("left_arm_part" + i, CubeListBuilder.create().texOffs(56, 2 + i * 2).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, true), PartPose.offset((float)0.0f, (float)(i == 0 ? 1.0f : 2.0f), (float)0.0f));
        }
        return layerDefinition;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.creepy && (!this.carrying || FlailingEndermanElement.whileCarrying)) {
            float animationSpeed = (float)FlailingEndermanElement.animationSpeed * 0.025f;
            if (!this.carrying) {
                this.rightArm.zRot = 2.6f;
                this.leftArm.zRot = -2.6f;
                this.rightArm.xRot = 0.0f;
                this.leftArm.xRot = 0.0f;
                for (int i = 0; i < 12; ++i) {
                    float armPartZRot;
                    this.rightArmParts[i].zRot = armPartZRot = Mth.sin((float)(ageInTicks * animationSpeed * 7.0f + (float)i * 0.45f)) * ((float)(i + 8) / 8.0f) * animationSpeed;
                    this.leftArmParts[i].zRot = -armPartZRot;
                }
            } else {
                for (int i = 0; i < 12; ++i) {
                    int j = i > 6 ? 12 - i : i;
                    float armPartZRot = Mth.sin((float)(ageInTicks * animationSpeed * 5.0f + (float)j * 0.45f)) * ((float)(j + 8) / 8.0f) * animationSpeed;
                    this.leftArmParts[i].zRot = i != j ? -armPartZRot : armPartZRot;
                    this.rightArmParts[i].zRot = this.leftArmParts[i].zRot;
                }
            }
        } else {
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            for (int i = 0; i < 12; ++i) {
                this.leftArmParts[i].zRot = 0.0f;
                this.rightArmParts[i].zRot = 0.0f;
            }
        }
    }
}

