/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.model.KneesModel;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class HumanoidKneesModel<T extends LivingEntity>
extends HumanoidModel<T>
implements KneesModel {
    private final ModelPart rightShin;
    private final ModelPart leftShin;

    public HumanoidKneesModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart rightLeg = modelPart.getChild("right_leg");
        this.rightShin = rightLeg.getChild("right_shin");
        ModelPart leftLeg = modelPart.getChild("left_leg");
        this.leftShin = leftLeg.getChild("left_shin");
    }

    public static MeshDefinition createAnimatedMesh(CubeDeformation cubeDeformation, float offsetY) {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)offsetY);
        PartDefinition partDefinition = meshDefinition.getRoot();
        Pair<CubeListBuilder, PartPose> rightLeg = HumanoidKneesModel.createShin(0, 16, -1.9f, 0.0f, 0.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftLeg = HumanoidKneesModel.createShin(0, 16, 1.9f, 0.0f, 0.0f, true, cubeDeformation);
        Pair<CubeListBuilder, PartPose> rightShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, false, cubeDeformation);
        Pair<CubeListBuilder, PartPose> leftShin = HumanoidKneesModel.createShin(0, 22, 0.0f, -6.0f, -2.0f, true, cubeDeformation);
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("right_leg", (CubeListBuilder)rightLeg.left(), (PartPose)rightLeg.right());
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("left_leg", (CubeListBuilder)leftLeg.left(), (PartPose)leftLeg.right());
        partDefinition1.addOrReplaceChild("right_shin", (CubeListBuilder)rightShin.left(), (PartPose)rightShin.right());
        partDefinition2.addOrReplaceChild("left_shin", (CubeListBuilder)leftShin.left(), (PartPose)leftShin.right());
        return meshDefinition;
    }

    public static Pair<CubeListBuilder, PartPose> createShin(int textureX, int textureY, float offsetX, float offsetY, float offsetZ, boolean mirror, CubeDeformation cubeDeformation) {
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(textureX, textureY);
        if (mirror) {
            cubeListBuilder.mirror();
        }
        cubeListBuilder.addBox(-2.0f, 0.0f, -2.0f - offsetZ, 4.0f, 6.0f, 4.0f, cubeDeformation);
        return Pair.of((Object)cubeListBuilder, (Object)PartPose.offset((float)offsetX, (float)(12.0f + offsetY), (float)offsetZ));
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        KneesModel.setupAnim(this, entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void copyPropertiesTo(HumanoidModel<T> model) {
        super.copyPropertiesTo(model);
        KneesModel.copyPropertiesTo(this, model);
    }

    @Override
    public ModelPart rightShin() {
        return this.rightShin;
    }

    @Override
    public ModelPart leftShin() {
        return this.leftShin;
    }
}

