/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import java.util.Arrays;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Slime;

public class MagmaCubeBurgerModel<T extends Slime>
extends LavaSlimeModel<T> {
    private final ModelPart insideCube;
    private final ModelPart[] bodyCubes = new ModelPart[8];

    public MagmaCubeBurgerModel(ModelPart modelPart) {
        super(modelPart);
        this.insideCube = modelPart.getChild("inside_cube");
        Arrays.setAll(this.bodyCubes, i -> modelPart.getChild("cube" + i));
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float deathTime = Math.min(10.0f, (float)((Slime)entitylivingbaseIn).deathTime);
        this.insideCube.visible = deathTime <= 0.0f;
        float squishFactor = Math.max(0.0f, Mth.lerp((float)partialTickTime, (float)((Slime)entitylivingbaseIn).oSquish, (float)((Slime)entitylivingbaseIn).squish));
        for (int i = 0; i < this.bodyCubes.length; ++i) {
            this.bodyCubes[i].y = (float)(-(4 - i)) * squishFactor * 1.7f;
            this.bodyCubes[i].y += (float)(10 - i) * deathTime * 0.325f;
            this.bodyCubes[i].x = deathTime * 2.0f - (deathTime <= 0.0f ? 0.0f : (float)(7 - i) * 0.675f);
            this.bodyCubes[i].zRot = deathTime * 0.195f;
            this.bodyCubes[i].yRot = (float)(5 * i % 7 - 3) * deathTime * 0.05f;
        }
    }
}

