/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.OinkyPigElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class OinkyPigModel<T extends Entity>
extends PigModel<T> {
    private final ModelPart snout;
    private final ModelPart rightEar;
    private final ModelPart leftEar;

    public OinkyPigModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart head = modelPart.getChild("head");
        this.snout = head.getChild("snout");
        this.rightEar = head.getChild("right_ear");
        this.leftEar = head.getChild("left_ear");
    }

    public static LayerDefinition createAnimatedBodyLayer(CubeDeformation cubeDeformation) {
        LayerDefinition layerDefinition = PigModel.createBodyLayer((CubeDeformation)cubeDeformation);
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)12.0f, (float)-6.0f));
        partDefinition1.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(16, 16).addBox(-2.0f, -3.0f, -1.0f, 4.0f, 3.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)3.0f, (float)-8.0f));
        partDefinition1.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(16, 4).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offset((float)3.5f, (float)-2.0f, (float)-4.0f));
        partDefinition1.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(16, 4).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.5f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        return layerDefinition;
    }

    public void prepareMobModel(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (entitylivingbaseIn instanceof Mob) {
            Mob mob = (Mob)entitylivingbaseIn;
            int soundTime = mob.ambientSoundTime + mob.getAmbientSoundInterval();
            if (0 < soundTime && soundTime < 8) {
                float rotation = Mth.sin((float)((float)soundTime * 0.3926991f));
                this.snout.y = 3.0f - rotation;
            } else {
                this.snout.y = 3.0f;
            }
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightEar.visible = OinkyPigElement.floatyEars;
        this.leftEar.visible = OinkyPigElement.floatyEars;
        if (OinkyPigElement.floatyEars) {
            float f1 = ageInTicks * 0.1f + limbSwing * 0.5f;
            float f2 = 0.08f + limbSwingAmount * (float)OinkyPigElement.earAnimationSpeed * 0.04f;
            this.rightEar.zRot = -0.5235988f - Mth.cos((float)(f1 * 1.2f)) * f2;
            this.leftEar.zRot = 0.5235988f + Mth.cos((float)f1) * f2;
        }
    }
}

