/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.betteranimationscollection.client.element.WobblyCreeperElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class WobblyCreeperModel<T extends Entity>
extends CreeperModel<T> {
    private final ModelPart body;
    private final ModelPart[] bodyParts;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final boolean chargedModel;

    public WobblyCreeperModel(ModelPart modelPart, boolean chargedModel) {
        super(modelPart);
        this.body = modelPart.getChild("body");
        this.bodyParts = new ModelPart[chargedModel ? 4 : 11];
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i] = i == 0 ? this.body.getChild("body" + i) : this.bodyParts[i - 1].getChild("body" + i);
        }
        this.head = this.bodyParts[this.bodyParts.length - 1].getChild("head");
        this.leftHindLeg = modelPart.getChild("right_hind_leg");
        this.rightHindLeg = modelPart.getChild("left_hind_leg");
        this.leftFrontLeg = modelPart.getChild("right_front_leg");
        this.rightFrontLeg = modelPart.getChild("left_front_leg");
        this.chargedModel = chargedModel;
    }

    public static LayerDefinition createAnimatedBodyLayer(CubeDeformation cubeDeformation, boolean chargedModel) {
        int partHeight = chargedModel ? 3 : 1;
        LayerDefinition layerDefinition = CreeperModel.createBodyLayer((CubeDeformation)cubeDeformation);
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition lastBodyPart = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 27).addBox(-4.0f, 12.0f - (float)partHeight, -2.0f, 8.0f, (float)partHeight, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        for (int i = 0; i < (chargedModel ? 4 : 11); ++i) {
            lastBodyPart = lastBodyPart.addOrReplaceChild("body" + i, CubeListBuilder.create().texOffs(16, 27 - partHeight - i * partHeight).addBox(-4.0f, (float)partHeight, -2.0f, 8.0f, (float)partHeight, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(i == 0 ? 9.0f : (float)(-partHeight)), (float)0.0f));
        }
        lastBodyPart.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)18.0f, (float)2.0f));
        partDefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)18.0f, (float)2.0f));
        partDefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)18.0f, (float)-2.0f));
        partDefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)18.0f, (float)-2.0f));
        return layerDefinition;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg).forEach(modelPart -> modelPart.render(poseStack, vertexConsumer, i, j, f, g, h, k));
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        WobblyCreeperElement.WobbleDirection wobbleDirection = WobblyCreeperElement.wobbleDirection;
        if (wobbleDirection == WobblyCreeperElement.WobbleDirection.RANDOM) {
            wobbleDirection = WobblyCreeperElement.WobbleDirection.values()[(int)Math.abs(entityIn.getUUID().getLeastSignificantBits() % (long)(WobblyCreeperElement.WobbleDirection.values().length - 1))];
        }
        float magnitude = this.resolveMagnitude(limbSwingAmount * 3.5f);
        float cosSwing = magnitude * Mth.cos((float)(limbSwing * 0.6662f)) * (float)(this.chargedModel ? 3 : 1);
        float sinSwing = magnitude * Mth.sin((float)(limbSwing * 0.6662f)) * (float)(this.chargedModel ? 3 : 1);
        block5: for (ModelPart bodyPart : this.bodyParts) {
            switch (wobbleDirection) {
                case SIDE: {
                    bodyPart.xRot = 0.0f;
                    bodyPart.zRot = cosSwing;
                    continue block5;
                }
                case FRONT: {
                    bodyPart.xRot = cosSwing;
                    bodyPart.zRot = 0.0f;
                    continue block5;
                }
                case CIRCLE: {
                    bodyPart.xRot = sinSwing;
                    bodyPart.zRot = cosSwing;
                }
            }
        }
    }

    private float resolveMagnitude(float limbSwingAmount) {
        if (limbSwingAmount < 0.0f) {
            return 0.0f;
        }
        if (limbSwingAmount < 0.6f) {
            return 0.125f * limbSwingAmount;
        }
        return 0.075f;
    }
}

