/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.betteranimationscollection.client.element.FlailingEndermanElement;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CarriedBlockLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;

public class FlailingCarriedBlockLayer
extends CarriedBlockLayer {
    private final BlockRenderDispatcher blockRenderer;

    public FlailingCarriedBlockLayer(RenderLayerParent<EnderMan, EndermanModel<EnderMan>> renderLayerParent, BlockRenderDispatcher blockRenderDispatcher) {
        super(renderLayerParent, blockRenderDispatcher);
        this.blockRenderer = blockRenderDispatcher;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, EnderMan livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        BlockState blockstate = livingEntity.getCarriedBlock();
        if (blockstate != null) {
            matrixStack.pushPose();
            double flailAmount = 0.0;
            if (FlailingEndermanElement.whileCarrying && livingEntity.isCreepy()) {
                float animationSpeed = (float)FlailingEndermanElement.animationSpeed * 0.025f;
                double armPartLength = 2.0;
                double totalAngle = 0.0;
                for (int i = 0; i < 12; ++i) {
                    int j = i > 6 ? 12 - i : i;
                    float armPartZRot = Mth.sin((float)(ageInTicks * animationSpeed * 5.0f + (float)j * 0.45f)) * ((float)(j + 8) / 8.0f) * animationSpeed;
                    flailAmount += Math.tan(totalAngle += i != j ? (double)(-armPartZRot) : (double)armPartZRot) * 2.0;
                }
            }
            matrixStack.translate(-flailAmount * 0.0575, 0.6875, -0.75);
            matrixStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(45.0f));
            matrixStack.translate(0.25, 0.1875, 0.25);
            matrixStack.scale(-0.5f, -0.5f, 0.5f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.blockRenderer.renderSingleBlock(blockstate, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
            matrixStack.popPose();
        }
    }
}

