/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGreyout;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public abstract class Workspace
extends Screen
implements Rectangle {
    public static final long CURSOR_ARROW = GLFW.glfwCreateStandardCursor((int)221185);
    public static final long CURSOR_IBEAM = GLFW.glfwCreateStandardCursor((int)221186);
    public static final long CURSOR_CROSSHAIR = GLFW.glfwCreateStandardCursor((int)221187);
    public static final long CURSOR_HAND = GLFW.glfwCreateStandardCursor((int)221188);
    public static final long CURSOR_HRESIZE = GLFW.glfwCreateStandardCursor((int)221189);
    public static final long CURSOR_VRESIZE = GLFW.glfwCreateStandardCursor((int)221190);
    public static final String ELLIPSIS = "\u2026";
    public int ellipsisLength = 0;
    public Screen lastScreen;
    private boolean hasInit;
    public String lastTooltip;
    public int tooltipCooldown;
    public Theme theme;
    public int renderMinecraftStyle;
    public long cursorState;
    public ArrayList<Window<?, ?>> windows = new ArrayList();

    protected Workspace(Screen lastScreen, Component title) {
        super(title);
        this.lastScreen = lastScreen;
        this.theme = Theme.getInstance();
        this.renderMinecraftStyle = iChunUtil.configClient.bnsMinecraftStyle;
        if (this.canDockWindows()) {
            this.windows.add(new WindowDock<Workspace>(this));
        }
    }

    public <W extends Workspace> W setTheme(Theme theme) {
        this.theme = theme;
        return (W)this;
    }

    public <W extends Workspace> W setMinecraftStyle(int i) {
        this.renderMinecraftStyle = i;
        return (W)this;
    }

    protected void init() {
        if (!this.hasInit) {
            this.hasInit = true;
            this.ellipsisLength = this.getFontRenderer().width(ELLIPSIS);
            this.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)Fragment::init));
        }
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void resize(Minecraft mc, int width, int height) {
        this.minecraft = mc;
        this.font = mc.font;
        this.width = width;
        this.height = height;
        this.setFocused(null);
        this.windows.forEach((Consumer<Window<?, ?>>)((Consumer<Window>)window -> window.resize(mc, width, height)));
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void removed() {
        GLFW.glfwSetCursor((long)this.minecraft.getWindow().getWindow(), (long)0L);
    }

    public List<Window<?, ?>> children() {
        if (this.canDockWindows()) {
            ArrayList winds = new ArrayList();
            for (int i = 0; i < this.windows.size(); ++i) {
                Window<?, ?> window = this.windows.get(i);
                if (window instanceof WindowDock) {
                    ((WindowDock)window).docked.keySet().forEach(h -> winds.addAll(h.windows()));
                    continue;
                }
                winds.add(window);
            }
            winds.remove(this.getDock());
            return winds;
        }
        return this.windows;
    }

    public void tick() {
        this.children().forEach(Fragment::tick);
        --this.tooltipCooldown;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.cursorState = CURSOR_ARROW;
        graphics.pose().pushPose();
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.renderWindows(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY, partialTick);
        this.resetBackground();
        graphics.pose().popPose();
        GLFW.glfwSetCursor((long)this.minecraft.getWindow().getWindow(), (long)this.cursorState);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle > 0) {
            super.renderBackground(graphics, mouseX, mouseY, partialTick);
        } else {
            RenderSystem.clearColor((float)((float)this.getTheme().workspaceBackground[0] / 255.0f), (float)((float)this.getTheme().workspaceBackground[1] / 255.0f), (float)((float)this.getTheme().workspaceBackground[2] / 255.0f), (float)255.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
        }
    }

    public void resetBackground() {
    }

    public void renderWindows(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window<?, ?> window = this.windows.get(i);
            graphics.pose().translate(0.0, 0.0, 10.0);
            window.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Fragment<?> topMost = this.getTopMostFragment(mouseX, mouseY);
        if (topMost != null) {
            String tooltip = topMost.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                if (!tooltip.equals(this.lastTooltip)) {
                    this.lastTooltip = tooltip;
                    this.tooltipCooldown = iChunUtil.configClient.bnsTooltipCooldown;
                }
            } else {
                this.lastTooltip = null;
            }
        }
        if (this.lastTooltip != null && this.tooltipCooldown < 0) {
            this.renderTooltip(graphics, this.lastTooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(GuiGraphics graphics, @NotNull String tooltip, int mouseX, int mouseY) {
        List textStrings = Splitter.on((String)"\n").splitToList((CharSequence)tooltip);
        if (this.renderMinecraftStyle > 0) {
            ArrayList<MutableComponent> textLines = new ArrayList<MutableComponent>();
            for (String s : textStrings) {
                textLines.add(Component.literal((String)s));
            }
            graphics.renderTooltip(this.font, textLines, Optional.empty(), mouseX, mouseY);
        } else {
            int n;
            ArrayList<MutableComponent> textLines = new ArrayList<MutableComponent>();
            for (String s : textStrings) {
                textLines.add(Component.literal((String)s));
            }
            int screenWidth = this.width;
            int screenHeight = this.height;
            int maxTextWidth = -1;
            Font font = this.getFontRenderer();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (FormattedText formattedText : textLines) {
                int textLineWidth = font.width(formattedText);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
                for (int i = 0; i < textLines.size(); ++i) {
                    FormattedText textLine = (FormattedText)textLines.get(i);
                    List wrappedLine = font.getSplitter().splitLines(textLine, tooltipTextWidth, Style.EMPTY);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (FormattedText line : wrappedLine) {
                        int lineWidth = font.width(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            PoseStack stack = graphics.pose();
            int zLevel = 400;
            stack.pushPose();
            Matrix4f mat = stack.last().pose();
            RenderHelper.drawColour(graphics, this.getTheme().windowBorderActive, 255, (double)(tooltipX - 3), (double)(tooltipY - 3), (double)(tooltipTextWidth + 6), (double)(tooltipHeight + 6), 400.0);
            RenderHelper.drawColour(graphics, this.getTheme().windowBackground, 255, (double)(tooltipX - 2), (double)(tooltipY - 2), (double)(tooltipTextWidth + 4), (double)(tooltipHeight + 4), 400.0);
            MultiBufferSource.BufferSource renderType = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
            stack.translate(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                FormattedText line = (FormattedText)textLines.get(lineNumber);
                if (line != null) {
                    font.drawInBatch(Language.getInstance().getVisualOrder(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.endBatch();
            stack.popPose();
            RenderSystem.enableDepthTest();
        }
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@NotNull String id) {
        T o = null;
        for (GuiEventListener guiEventListener : this.children()) {
            if (o != null || !(guiEventListener instanceof Fragment)) continue;
            Fragment fragment = (Fragment)guiEventListener;
            o = fragment.getById(id);
        }
        return o;
    }

    @Nullable
    public <T extends View<?>> T getByViewType(Class<T> clz) {
        List<Window<?, ?>> windows = this.children();
        for (Window<?, ?> window : windows) {
            if (!clz.isAssignableFrom(window.getCurrentView().getClass())) continue;
            return (T)window.getCurrentView();
        }
        return null;
    }

    @Nullable
    public <T extends Window<?, ?>> T getByWindowType(Class<T> clz) {
        List<Window<?, ?>> windows = this.children();
        for (Window<?, ?> window : windows) {
            if (!clz.isAssignableFrom(window.getClass())) continue;
            return (T)window;
        }
        return null;
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        List<Window<?, ?>> children = this.children();
        for (Window<?, ?> child : children) {
            Fragment<?> frag = child.getTopMostFragment(mouseX, mouseY);
            if (frag == null) continue;
            return frag;
        }
        return null;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        return super.mouseDragged(mouseX, mouseY, button, distX, distY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    public boolean isObstructed(Window<?, ?> window, double mouseX, double mouseY) {
        for (Window<?, ?> window1 : this.children()) {
            if (!Fragment.isMouseBetween(mouseX, window1.getLeft(), window1.getLeft() + window1.width) || !Fragment.isMouseBetween(mouseY, window1.getTop(), window1.getTop() + window1.height)) continue;
            return window != window1;
        }
        return true;
    }

    public Window<?, ?> addWindow(Window<?, ?> window) {
        if (window.isUnique()) {
            List<Window<?, ?>> allWindows = this.children();
            for (int i = allWindows.size() - 1; i >= 0; --i) {
                Window<?, ?> window1 = allWindows.get(i);
                if (window1.getClass() != window.getClass()) continue;
                if (this.isDocked(window1)) {
                    window1.onClose();
                    this.getDock().removeFromDock(window1);
                    continue;
                }
                this.removeWindow(window1);
            }
        }
        this.windows.add(0, window);
        return window;
    }

    public void removeWindow(Window<?, ?> window) {
        if (this.getFocused() == window) {
            this.setFocused(null);
        }
        window.onClose();
        this.windows.remove(window);
    }

    public void bringToFront(Window<?, ?> window) {
        if (window.canBringToFront() && this.windows.remove(window)) {
            this.addWindow(window);
        }
    }

    public void putInCenter(Window<?, ?> window) {
        if (!this.isDocked(window)) {
            window.pos((int)((double)(this.getWidth() - window.getWidth()) / 2.0), (int)((double)(this.getHeight() - window.getHeight()) / 2.0));
        }
    }

    public void openWindowInCenter(Window<?, ?> window, double widthRatio, double heightRatio, boolean greyout) {
        if (widthRatio <= 1.0) {
            window.setWidth((int)((double)window.getParentWidth() * widthRatio));
        } else {
            window.setWidth((int)widthRatio);
        }
        if (heightRatio <= 1.0) {
            window.setHeight((int)((double)window.getParentHeight() * heightRatio));
        } else {
            window.setHeight((int)heightRatio);
        }
        if (greyout) {
            this.addWindowWithGreyout(window);
        } else {
            this.addWindow(window);
        }
        this.putInCenter(window);
        this.setFocused((GuiEventListener)window);
        window.init();
    }

    public void openWindowInCenter(Window<?, ?> window, double widthRatio, double heightRatio) {
        this.openWindowInCenter(window, widthRatio, heightRatio, false);
    }

    public void openWindowInCenter(Window<?, ?> window, boolean greyout) {
        this.openWindowInCenter(window, 0.5, 0.5, greyout);
    }

    public void openWindowInCenter(Window<?, ?> window) {
        this.openWindowInCenter(window, false);
    }

    public void addWindowWithGreyout(Window<?, ?> window) {
        WindowGreyout<Workspace> greyout = new WindowGreyout<Workspace>(this, window);
        this.addWindow(greyout);
        greyout.init();
        this.addWindow(window);
    }

    public boolean canDockWindows() {
        return true;
    }

    public WindowDock<? extends Workspace> getDock() {
        return (WindowDock)this.windows.get(this.windows.size() - 1);
    }

    public WindowDock.DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        if (this.canDockWindows()) {
            return this.getDock().getDockInfo(mouseX, mouseY, dockStack);
        }
        return null;
    }

    public void addToDocked(Window<?, ?> docked, Window<?, ?> window) {
        if (this.canDockWindows() && this.getDock().addToDocked(docked, window)) {
            this.removeWindow(window);
        }
    }

    public void addToDock(Window<?, ?> window, Constraint.Property.Type type) {
        if (this.canDockWindows()) {
            this.getDock().addToDock(window, type);
            this.removeWindow(window);
        }
    }

    public void removeFromDock(Window<?, ?> window, boolean addWindow) {
        if (this.canDockWindows()) {
            this.getDock().removeFromDock(window);
            if (addWindow) {
                this.addWindow(window);
            } else {
                this.removeWindow(window);
            }
        }
    }

    public void removeFromDock(Window<?, ?> window) {
        this.removeFromDock(window, true);
    }

    public boolean isDocked(Window<?, ?> window) {
        if (this.canDockWindows()) {
            return this.getDock().isDocked(window);
        }
        return false;
    }

    public boolean sameDockStack(Rectangle window, Rectangle window1) {
        if (this.canDockWindows()) {
            return this.getDock().sameDockStack(window, window1);
        }
        return false;
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public int getRight() {
        return this.width;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getBottom() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <W extends Workspace> W getWorkspace() {
        return (W)this;
    }

    @Override
    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public Font getFontRenderer() {
        return this.font;
    }

    @Override
    public int renderMinecraftStyle() {
        return this.renderMinecraftStyle;
    }

    public void setFocused(@Nullable GuiEventListener gui) {
        GuiEventListener lastFocused = this.getFocused();
        if (lastFocused instanceof Fragment && gui != lastFocused) {
            ((Fragment)lastFocused).unfocus(gui);
        }
        if (gui instanceof Window) {
            this.bringToFront((Window)gui);
        }
        super.setFocused(gui);
    }

    public static void bindTexture(ResourceLocation rl) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)rl);
    }
}

